/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.recipe.MalumIngredientTypes;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.NotNull;

public record SpiritIngredient(Holder<SpiritArcanaType> spirit, int count) implements ICustomIngredient,
SpiritLike
{
    public static final MapCodec<SpiritIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SpiritArcanaType.HOLDER_CODEC.fieldOf("type").forGetter(SpiritIngredient::spirit), (App)Codec.INT.fieldOf("count").forGetter(SpiritIngredient::count)).apply((Applicative)builder, SpiritIngredient::new));

    public boolean test(ItemStack itemStack) {
        return itemStack.is((Item)((SpiritArcanaType)this.spirit.value()).getSpiritShard()) && itemStack.getCount() >= this.count;
    }

    @NotNull
    public Stream<ItemStack> getItems() {
        return Stream.of(this.asItemStack());
    }

    @NotNull
    public IngredientType<?> getType() {
        return (IngredientType)MalumIngredientTypes.SPIRIT.get();
    }

    public ItemStack asItemStack() {
        return ((SpiritArcanaType)this.spirit().value()).getSpiritStack(this.count);
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    @NotNull
    public SpiritArcanaType getSpirit() {
        return ((SpiritArcanaType)this.spirit.value()).getSpirit();
    }
}

