/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

public class MalignantConversionReloadListener
extends SimpleJsonResourceReloadListener {
    public static Map<Holder<Attribute>, MalignantConversionData> CONVERSION_DATA = new HashMap<Holder<Attribute>, MalignantConversionData>();
    private static final Gson GSON = new GsonBuilder().create();

    public MalignantConversionReloadListener() {
        super(GSON, "malignant_conversion_data");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new MalignantConversionReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        CONVERSION_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            double consumptionRatio = object.has("ratio") ? object.get("ratio").getAsDouble() : 1.0;
            boolean ignoreBaseValue = object.has("ignore_base_value") && object.get("ignore_base_value").getAsBoolean();
            ArrayList<Holder<Attribute>> sourceAttributes = MalignantConversionReloadListener.getSourceAttributes(object);
            List<MalignantConversionAttributePayout> payoutData = MalignantConversionReloadListener.getPayoutData(object);
            for (Holder<Attribute> sourceAttribute : sourceAttributes) {
                MalignantConversionData data = new MalignantConversionData(sourceAttribute, consumptionRatio, ignoreBaseValue, payoutData);
                CONVERSION_DATA.put(sourceAttribute, data);
            }
        }
    }

    protected static ArrayList<Holder<Attribute>> getSourceAttributes(JsonObject object) {
        ArrayList<String> ids = new ArrayList<String>();
        if (object.has("source_attribute")) {
            String name = object.getAsJsonPrimitive("source_attribute").getAsString();
            ids.add(name);
        } else if (object.has("source_attributes")) {
            JsonArray sourceAttributes = object.getAsJsonArray("source_attributes");
            for (JsonElement sourceAttribute : sourceAttributes) {
                ids.add(sourceAttribute.getAsString());
            }
        }
        return ids.stream().map(MalignantConversionReloadListener::mapAttribute).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
    }

    protected static List<MalignantConversionAttributePayout> getPayoutData(JsonObject object) {
        ArrayList<MalignantConversionAttributePayout> payouts = new ArrayList<MalignantConversionAttributePayout>();
        if (object.has("target_attribute")) {
            Optional<MalignantConversionAttributePayout> payout = MalignantConversionReloadListener.getPayout(object.get("target_attribute").getAsJsonObject());
            payout.ifPresent(payouts::add);
        } else if (object.has("target_attributes")) {
            JsonArray array = object.getAsJsonArray("target_attributes");
            for (JsonElement jsonElement : array) {
                if (!jsonElement.isJsonObject()) continue;
                Optional<MalignantConversionAttributePayout> payout = MalignantConversionReloadListener.getPayout(jsonElement.getAsJsonObject());
                payout.ifPresent(payouts::add);
            }
        }
        return payouts;
    }

    public static Optional<MalignantConversionAttributePayout> getPayout(JsonObject object) {
        if (object.has("attribute")) {
            String attribute = object.getAsJsonPrimitive("attribute").getAsString();
            double ratio = object.has("ratio") ? object.getAsJsonPrimitive("ratio").getAsDouble() : 1.0;
            return MalignantConversionReloadListener.mapAttribute(attribute).map(a -> new MalignantConversionAttributePayout((Holder<Attribute>)a, ratio));
        }
        return Optional.empty();
    }

    public static Optional<Holder<Attribute>> mapAttribute(String id) {
        ResourceKey attributeKey = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)ResourceLocation.parse((String)id));
        Optional attributeHolder = BuiltInRegistries.ATTRIBUTE.getHolder(attributeKey);
        if (attributeHolder.isEmpty()) {
            MalumMod.LOGGER.warn("Malignant conversion data references an attribute that does not exist: {}", (Object)id);
            return Optional.empty();
        }
        return Optional.of((Holder)attributeHolder.get());
    }

    public record MalignantConversionData(Holder<Attribute> sourceAttribute, double consumptionRatio, boolean ignoreBaseValue, List<MalignantConversionAttributePayout> payoutData) {
    }

    public record MalignantConversionAttributePayout(Holder<Attribute> attribute, double ratio) {
    }
}

