/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.CurioData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class HiddenBladeRenderHandler {
    public static int fadeOut = 80;

    public static void tick(ClientTickEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            int cooldown = ((CurioData)player.getData(MalumAttachmentTypes.CURIO_DATA)).hiddenBladeNecklaceCooldown;
            if (cooldown == 0) {
                if (player.hasEffect(MalumMobEffects.WICKED_INTENT)) {
                    if (fadeOut > 30) {
                        fadeOut = 30;
                    }
                    fadeOut -= 2;
                    return;
                }
                if (fadeOut < 0) {
                    fadeOut = 20;
                } else if (fadeOut < 80) {
                    ++fadeOut;
                }
                return;
            }
            fadeOut = 0;
        }
    }

    public static void renderHiddenBladeCooldown(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int cooldown;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        if (!(minecraft.options.hideGui || (player = minecraft.player).isCreative() || player.isSpectator() || (cooldown = ((CurioData)player.getData(MalumAttachmentTypes.CURIO_DATA)).hiddenBladeNecklaceCooldown) <= 0 && fadeOut > 80)) {
            int yOffset;
            int left = guiGraphics.guiWidth() / 2 - 8;
            int top = guiGraphics.guiHeight() - 52;
            poseStack.pushPose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HiddenBladeRenderHandler.getTexture());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
            shaderInstance.safeGetUniform("YFrequency").set(15.0f);
            shaderInstance.safeGetUniform("XFrequency").set(15.0f);
            shaderInstance.safeGetUniform("Speed").set(550.0f);
            shaderInstance.safeGetUniform("Intensity").set(120.0f);
            VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance);
            float size = 16.0f;
            double delta = Mth.clamp((float)((float)(200 - cooldown) / 200.0f), (float)0.0f, (float)1.0f);
            boolean secondRow = (delta -= 0.125) >= 0.5;
            int xOffset = 16 * Mth.floor((double)(delta * 8.0)) - (secondRow ? 64 : 0);
            int n = yOffset = secondRow ? 16 : 0;
            if (fadeOut > 20) {
                boolean hasEffect = player.hasEffect(MalumMobEffects.WICKED_INTENT);
                builder.setAlpha((float)(80 - fadeOut) / (hasEffect ? 10.0f : 60.0f));
            }
            builder.setPositionWithWidth((float)left, (float)top, size, size).setUVWithWidth((float)xOffset, (float)yOffset, 16.0f, 16.0f, 64.0f).blit(poseStack);
            if (fadeOut > 0 && fadeOut < 20) {
                float glow = (float)(10 - Math.abs(10 - fadeOut)) / 10.0f;
                RenderSystem.blendFunc((int)770, (int)1);
                builder.setAlpha(glow).blit(poseStack);
            }
            shaderInstance.setUniformDefaults();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
    }

    public static ResourceLocation getTexture() {
        return MalumMod.malumPath("textures/gui/hud/hidden_blade.png");
    }
}

