/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.MalignantInfluenceData;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.SoundHelper;

public class MalignantConversionHandler {
    public static final ResourceLocation NEGATIVE_MODIFIER_ID = MalumMod.malumPath("malignant_conversion_tally");
    public static final Function<Holder<Attribute>, ResourceLocation> POSITIVE_MODIFIER_IDS = Util.memoize(MalignantConversionHandler::createPositiveModifierId);

    public static void shieldPlayer(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.is(MalumTags.DamageTypeTags.BYPASSES_MALIGNANT_AEGIS)) {
            return;
        }
        if (!(event.getOriginalAmount() >= 2.0f)) {
            return;
        }
        Optional<MalignantInfluenceData> optional = MalignantInfluenceData.getMalignantAegisData(entity);
        if (optional.isEmpty()) {
            return;
        }
        MalignantInfluenceData data = optional.get();
        int aegis = data.getMalignantAegis();
        if (aegis <= 0) {
            return;
        }
        data.reduceAegis(1);
        DamageContainer container = event.getContainer();
        int invulnerabilityTicks = Math.min(container.getPostAttackInvulnerabilityTicks() * 2, 40);
        container.setPostAttackInvulnerabilityTicks(invulnerabilityTicks);
        entity.syncData(MalumAttachmentTypes.MALIGNANT_INFLUENCE);
        SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.MALIGNANT_AEGIS_HIT.get()), (float)0.25f, (float)1.0f);
        if (data.getMalignantAegis() == 0) {
            SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.MALIGNANT_AEGIS_DEPLETE.get()), (float)1.0f, (float)1.0f);
        }
        event.setCanceled(true);
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Level level = living.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        MalignantInfluenceData.getMalignantAegisData(living).ifPresent(data -> data.tickData(living));
        if (living instanceof Player ? (player = (Player)living).isSpectator() : level2.getGameTime() % 40L != 0L) {
            return;
        }
        MalignantConversionHandler.runConversionLogic(living);
    }

    private static void runConversionLogic(LivingEntity target) {
        AttributeInstance conversion = target.getAttribute(MalumAttributes.MALIGNANT_CONVERSION);
        if (conversion == null) {
            return;
        }
        if (!target.hasData(MalumAttachmentTypes.MALIGNANT_INFLUENCE) && !(conversion.getValue() > 0.0)) {
            return;
        }
        MalignantInfluenceData data = (MalignantInfluenceData)target.getData(MalumAttachmentTypes.MALIGNANT_INFLUENCE);
        Holder malignantConversionAttribute = conversion.getAttribute();
        Collection<MalignantConversionReloadListener.MalignantConversionData> conversions = MalignantConversionReloadListener.CONVERSION_DATA.values();
        boolean forcedUpdate = MalignantConversionHandler.checkForChanges(data, target, (Holder<Attribute>)malignantConversionAttribute);
        for (MalignantConversionReloadListener.MalignantConversionData conversionData : conversions) {
            if (!forcedUpdate && !MalignantConversionHandler.checkForChanges(data, target, conversionData.sourceAttribute())) continue;
            MalignantConversionHandler.tryConvertAttribute(target, conversion, data, conversionData);
        }
        data.cacheValue(conversion);
    }

    private static void tryConvertAttribute(LivingEntity target, AttributeInstance malignantConversion, MalignantInfluenceData cacheData, MalignantConversionReloadListener.MalignantConversionData conversionData) {
        Holder<Attribute> sourceAttribute = conversionData.sourceAttribute();
        AttributeInstance sourceInstance = target.getAttribute(sourceAttribute);
        if (sourceInstance == null) {
            return;
        }
        float conversionStrength = (float)malignantConversion.getValue();
        boolean hasMalignantConversion = conversionStrength > 0.0f;
        MalignantConversionHandler.removeNegativeModifier(sourceInstance);
        double convertedAmount = sourceInstance.getValue() - (conversionData.ignoreBaseValue() ? sourceInstance.getBaseValue() : 0.0);
        for (MalignantConversionReloadListener.MalignantConversionAttributePayout payout : conversionData.payoutData()) {
            Holder<Attribute> affectedAttribute = payout.attribute();
            AttributeInstance affectedInstance = target.getAttribute(affectedAttribute);
            double payoutRatio = payout.ratio();
            if (affectedInstance == null) continue;
            ResourceLocation id = POSITIVE_MODIFIER_IDS.apply(sourceAttribute);
            affectedInstance.removeModifier(id);
            double bonus = convertedAmount * (double)conversionStrength * payoutRatio;
            if (!(bonus > 0.0)) continue;
            AttributeModifier modifier = new AttributeModifier(id, bonus, AttributeModifier.Operation.ADD_VALUE);
            affectedInstance.addTransientModifier(modifier);
        }
        cacheData.cacheValue(sourceInstance);
        if (hasMalignantConversion) {
            double ratio = conversionData.consumptionRatio();
            double toll = (double)(-conversionStrength) * ratio;
            MalignantConversionHandler.addNegativeModifier(sourceInstance, toll);
        }
    }

    private static boolean checkForChanges(MalignantInfluenceData data, LivingEntity livingEntity, Holder<Attribute> attribute) {
        AttributeInstance instance = livingEntity.getAttribute(attribute);
        if (instance == null) {
            return false;
        }
        if (data.hasCachedValue(attribute)) {
            boolean isFullConversion;
            AttributeModifier modifier = instance.getModifier(NEGATIVE_MODIFIER_ID);
            boolean bl = isFullConversion = modifier != null && modifier.amount() <= -1.0;
            if (isFullConversion) {
                MalignantConversionHandler.removeNegativeModifier(instance);
            }
            double stored = data.getCachedValue(attribute);
            double real = instance.getValue();
            if (isFullConversion) {
                instance.addTransientModifier(modifier);
            }
            return stored != real;
        }
        return true;
    }

    private static void removeNegativeModifier(AttributeInstance attribute) {
        AttributeModifier modifier = attribute.getModifier(NEGATIVE_MODIFIER_ID);
        if (modifier != null) {
            attribute.removeModifier(modifier);
        }
    }

    private static void addNegativeModifier(AttributeInstance attribute, double toll) {
        AttributeModifier modifier = new AttributeModifier(NEGATIVE_MODIFIER_ID, toll, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        attribute.addTransientModifier(modifier);
    }

    private static ResourceLocation createPositiveModifierId(Holder<Attribute> attribute) {
        return MalumMod.malumPath("malignant_conversion_buff_from_" + BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.value())).getPath());
    }
}

