/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.core.helpers.ComponentHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import team.lodestar.lodestone.helpers.DataHelper;

public class KeywordTooltipHandler {
    public static List<String> ALLOWED_MODS = new ArrayList<String>(List.of("malum"));
    public static List<TooltipKeyword> KEYWORDS = new ArrayList<TooltipKeyword>();
    public static final TooltipKeyword AVARICE = KeywordTooltipHandler.addKeyword("avarice");
    public static final TooltipKeyword GLUTTONY = KeywordTooltipHandler.addKeyword("gluttony");
    public static final TooltipKeyword SOUL_WARD = KeywordTooltipHandler.addKeyword("soul_ward");
    public static final TooltipKeyword ARCANE_RESONANCE = KeywordTooltipHandler.addKeyword("arcane_resonance");

    public static void addKeywords(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        String modName = stack.getItemHolder().getKey().location().getNamespace();
        if (!ALLOWED_MODS.contains(modName)) {
            return;
        }
        List tooltip = event.getToolTip();
        ArrayList<TooltipKeyword> presentKeywords = new ArrayList<TooltipKeyword>();
        block0: for (TooltipKeyword keyword : KEYWORDS) {
            for (Component component : tooltip) {
                String raw = component.getString();
                if (!raw.contains(keyword.name)) continue;
                presentKeywords.add(keyword);
                continue block0;
            }
        }
        for (TooltipKeyword presentKeyword : presentKeywords) {
            int index = tooltip.size();
            if (event.getFlags().isAdvanced()) {
                --index;
            }
            tooltip.add(index, ComponentHelper.effectKeyword(presentKeyword, new Object[0]));
        }
    }

    public static TooltipKeyword addKeyword(String id) {
        TooltipKeyword keyword = new TooltipKeyword(id);
        KEYWORDS.add(keyword);
        return keyword;
    }

    public record TooltipKeyword(String id, String name) {
        public TooltipKeyword(String id) {
            this(id, DataHelper.toTitleCase((String)id, (String)"_"));
        }

        public String getLangKey() {
            return "malum.effect.keyword." + this.id;
        }
    }
}

