/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import team.lodestar.lodestone.systems.config.LodestoneConfig;

public class CommonConfig
extends LodestoneConfig {
    public static LodestoneConfig.ConfigValueHolder<Boolean> HIDE_RECIPES = new LodestoneConfig.ConfigValueHolder("malum", "common/progression", builder -> builder.comment("If set to true, malum will hide some of it's content related to a certain feature. This is the intended way to play the mod.").define("hide_recipes", true));
    public static LodestoneConfig.ConfigValueHolder<Boolean> AWARD_CODEX_ON_KILL = new LodestoneConfig.ConfigValueHolder("malum", "common/codex", builder -> builder.comment("If set to true, one of the first undead enemies a player slays will drop the encyclopedia arcana.").define("enableCodexDrop", true));
    public static LodestoneConfig.ConfigValueHolder<Boolean> NO_FANCY_SPIRITS = new LodestoneConfig.ConfigValueHolder("malum", "common/spirit", builder -> builder.comment("If set to true, any spirits dropped will simply take the form of an item.").define("noFancySpirits", false));
    public static LodestoneConfig.ConfigValueHolder<Boolean> SOULLESS_SPAWNERS = new LodestoneConfig.ConfigValueHolder("malum", "common/spirit/spawner", builder -> builder.comment("If set to true, mob spawners will create soulless mobs instead.").define("lameSpawners", false));
    public static LodestoneConfig.ConfigValueHolder<Boolean> USE_DEFAULT_SPIRIT_VALUES = new LodestoneConfig.ConfigValueHolder("malum", "common/spirit/defaults", builder -> builder.comment("Whether entities without spirit jsons will use the default spirit data for their category.").define("defaultSpiritValues", true));
    public static LodestoneConfig.ConfigValueHolder<Boolean> MAGIC_DAMAGE_REDUCED_ARMOR_PIERCING = new LodestoneConfig.ConfigValueHolder("malum", "common/magic_damage", builder -> builder.comment("If set to true, damage types tagged under malum:bypasses_half_armor will pierce only half of the player's armor stat, as opposed to piercing it entirely. In addition, armor will not take durability damage.").define("magicDamageReducedArmorPiercing", true));
    public static LodestoneConfig.ConfigValueHolder<Double> SOUL_WARD_PHYSICAL = new LodestoneConfig.ConfigValueHolder("malum", "common/soul_ward", builder -> builder.comment("Multiplier for physical damage taken while soul ward is active.").defineInRange("soulWardPhysical", (double)0.7f, 0.0, 1.0));
    public static LodestoneConfig.ConfigValueHolder<Double> SOUL_WARD_MAGIC = new LodestoneConfig.ConfigValueHolder("malum", "common/soul_ward", builder -> builder.comment("Multiplier for magic damage taken while soul ward is active.").defineInRange("soulWardMagic", (double)0.1f, 0.0, 1.0));
    public static LodestoneConfig.ConfigValueHolder<Integer> SOUL_WARD_RATE = new LodestoneConfig.ConfigValueHolder("malum", "common/soul_ward", builder -> builder.comment("Base time in ticks it takes for one point of soul ward to recover.").define("soulWardRate", (Object)100));
    public static LodestoneConfig.ConfigValueHolder<Integer> MALIGNANT_AEGIS_RATE = new LodestoneConfig.ConfigValueHolder("malum", "common/malignant_aegis", builder -> builder.comment("Base time in ticks it takes for one point of malignant aegis to recover.").define("malignantAegisRate", (Object)200));
    public static LodestoneConfig.ConfigValueHolder<Integer> STAFF_CHARGE_RATE = new LodestoneConfig.ConfigValueHolder("malum", "common/staff_charge", builder -> builder.comment("Base time in ticks it takes for one segment of a staff charge to recover.").define("staffChargeRate", (Object)100));
    public static LodestoneConfig.ConfigValueHolder<Boolean> IRONS_SPELLBOOKS_SPIRIT_DAMAGE = new LodestoneConfig.ConfigValueHolder("malum", "common/compat/irons_spellbooks", builder -> builder.comment("Should Iron's Spellbooks' magic damage count as Soul Damage?").define("ironsSpellbooksPlayerSpiritDrops", true));
    public static LodestoneConfig.ConfigValueHolder<Boolean> IRONS_SPELLBOOKS_NON_PLAYER_SPIRIT_DAMAGE = new LodestoneConfig.ConfigValueHolder("malum", "common/compat/irons_spellbooks", builder -> builder.comment("Should Iron's Spellbooks' magic damage when dealt by non-players count as Soul Damage").define("ironsSpellbooksNonPlayerSpiritDrops", true));
    public static final CommonConfig INSTANCE;
    public static final ModConfigSpec SPEC;

    public CommonConfig(ModConfigSpec.Builder builder) {
        super("malum", "common", builder);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (CommonConfig)((Object)specPair.getLeft());
    }
}

