/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.kubejs.component;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record SpiritJSComponent(RecipeComponentType<?> type) implements RecipeComponent<SpiritIngredient>
{
    private final RecipeComponentType<?> type;
    public static final Codec<SpiritIngredient> CODEC = SpiritIngredient.CODEC.codec();
    public static final RecipeComponentType<SpiritIngredient> SPIRIT_INGREDIENT = RecipeComponentType.unit((ResourceLocation)MalumMod.malumPath("spirit_ingredient"), SpiritJSComponent::new);

    public RecipeComponentType<?> type() {
        return SPIRIT_INGREDIENT;
    }

    public Codec<SpiritIngredient> codec() {
        return CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(SpiritIngredient.class);
    }

    @Override
    public String toString() {
        return this.type().id().getPath();
    }

    public SpiritIngredient wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            return (SpiritIngredient)((Pair)this.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow()).getFirst();
        }
        return SpiritJSComponent.fromObject(RegistryAccessContainer.of((Context)cx.cx()), from);
    }

    public static SpiritIngredient fromObject(RegistryAccessContainer registries, Object from) {
        if (from instanceof SpiritIngredient) {
            SpiritIngredient spiritIngredient = (SpiritIngredient)from;
            return spiritIngredient;
        }
        if (from instanceof SpiritShardItem) {
            SpiritShardItem shardItem = (SpiritShardItem)from;
            return SpiritJSComponent.fromItemStack(shardItem, 1);
        }
        if (from instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)from;
            return SpiritJSComponent.fromSizedIngredient(sizedIngredient);
        }
        if (from instanceof ItemStack) {
            ItemStack stack = (ItemStack)from;
            return SpiritJSComponent.fromItemStack(stack);
        }
        if (from instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)from;
            return SpiritJSComponent.fromItem(itemLike);
        }
        if (from instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)from;
            return SpiritJSComponent.fromItemStack(ingredient.getItems()[0]);
        }
        if (from instanceof CharSequence) {
            try {
                return SpiritJSComponent.read(new StringReader(from.toString()));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to read SpiritIngredient from string: " + String.valueOf(from), exception);
            }
        }
        throw new IllegalArgumentException("Can't create SpiritIngredient from object: " + String.valueOf(from));
    }

    public static SpiritIngredient read(StringReader reader) throws CommandSyntaxException {
        int count = 1;
        if (StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                throw new IllegalArgumentException("SpiritIngredient count smaller than 1 is not allowed!");
            }
        }
        reader.skipWhitespace();
        Object spirit = reader.readString();
        if (!((String)spirit).contains(":")) {
            spirit = "malum:" + (String)spirit;
        }
        ResourceLocation parse = ResourceLocation.parse((String)spirit);
        ResourceKey key = ResourceKey.create(MalumSpiritTypes.SPIRIT_TYPES_KEY, (ResourceLocation)parse);
        Holder.Reference spiritHolder = MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.getHolderOrThrow(key);
        return new SpiritIngredient((Holder<SpiritArcanaType>)spiritHolder, count);
    }

    public static SpiritIngredient fromSizedIngredient(SizedIngredient sizedIngredient) {
        ItemStack[] items = sizedIngredient.getItems();
        if (items.length < 1) {
            throw new IllegalArgumentException("Can't create SpiritIngredient");
        }
        Item item = items[0].getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem shardItem = (SpiritShardItem)item;
            return SpiritJSComponent.fromItemStack(shardItem, sizedIngredient.count());
        }
        throw new IllegalArgumentException("SizedIngredient must hold a SpiritShardItem to be converted to a SpiritIngredient!");
    }

    public static SpiritIngredient fromItem(ItemLike itemLike) {
        if (itemLike instanceof SpiritShardItem) {
            SpiritShardItem shardItem = (SpiritShardItem)itemLike;
            return SpiritJSComponent.fromItemStack(shardItem, 1);
        }
        throw new IllegalArgumentException("Can't create SpiritIngredient from ItemLike");
    }

    public static SpiritIngredient fromItemStack(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem shardItem = (SpiritShardItem)item;
            return SpiritJSComponent.fromItemStack(shardItem, stack.getCount());
        }
        throw new IllegalArgumentException("Can't create SpiritIngredient");
    }

    public static SpiritIngredient fromItemStack(SpiritShardItem shardItem, int count) {
        return new SpiritIngredient((Holder<SpiritArcanaType>)shardItem.getHolder(), count);
    }
}

