/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.jei;

import com.google.common.collect.Maps;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.recipe.RuneworkingRecipe;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.common.recipe.UnchainedTransmutationRecipe;
import com.sammy.malum.common.recipe.VoidFavorRecipe;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRecipe;
import com.sammy.malum.compat.farmersdelight.FarmersDelightCompat;
import com.sammy.malum.compat.jei.HiddenRecipeSet;
import com.sammy.malum.compat.jei.categories.RuneworkingRecipeCategory;
import com.sammy.malum.compat.jei.categories.SpiritFocusingRecipeCategory;
import com.sammy.malum.compat.jei.categories.SpiritInfusionRecipeCategory;
import com.sammy.malum.compat.jei.categories.SpiritRepairRecipeCategory;
import com.sammy.malum.compat.jei.categories.SpiritTransmutationRecipeCategory;
import com.sammy.malum.compat.jei.categories.WeepingWellRecipeCategory;
import com.sammy.malum.compat.jei.recipes.SpiritTransmutationWrapper;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.handlers.hiding.HiddenTagHandler;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.compress.utils.Lists;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

@JeiPlugin
public class JEIHandler
implements IModPlugin {
    private static final ResourceLocation ID = MalumMod.malumPath("main");
    public static final RecipeType<SpiritInfusionRecipe> SPIRIT_INFUSION = new RecipeType(SpiritInfusionRecipeCategory.UID, SpiritInfusionRecipe.class);
    public static final RecipeType<SpiritTransmutationWrapper> TRANSMUTATION = new RecipeType(SpiritTransmutationRecipeCategory.UID, SpiritTransmutationWrapper.class);
    public static final RecipeType<SpiritFocusingRecipe> FOCUSING = new RecipeType(SpiritFocusingRecipeCategory.UID, SpiritFocusingRecipe.class);
    public static final RecipeType<SpiritRepairRecipe> SPIRIT_REPAIR = new RecipeType(SpiritRepairRecipeCategory.UID, SpiritRepairRecipe.class);
    public static final RecipeType<VoidFavorRecipe> WEEPING_WELL = new RecipeType(WeepingWellRecipeCategory.UID, VoidFavorRecipe.class);
    public static final RecipeType<RuneworkingRecipe> RUNEWORKING = new RecipeType(RuneworkingRecipeCategory.UID, RuneworkingRecipe.class);
    private static final Set<ItemStack> HIDDEN_ITEMS = new LinkedHashSet<ItemStack>();
    private static final Map<RecipeType<?>, HiddenRecipeSet<?>> HIDDEN_RECIPE_SETS = new HashMap();
    private static final List<UUID> CALLBACKS = new ArrayList<UUID>();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritInfusionRecipeCategory(guiHelper), new SpiritTransmutationRecipeCategory(guiHelper), new SpiritFocusingRecipeCategory(guiHelper), new SpiritRepairRecipeCategory(guiHelper), new RuneworkingRecipeCategory(guiHelper), new WeepingWellRecipeCategory(guiHelper)});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            registry.addRecipes(SPIRIT_INFUSION, LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.SPIRIT_INFUSION.get())));
            List transmutation = LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.UNCHAINED_TRANSMUTATION.get()));
            ArrayList leftovers = Lists.newArrayList();
            LinkedHashMap groups = Maps.newLinkedHashMap();
            for (UnchainedTransmutationRecipe recipe : transmutation) {
                if (!recipe.getGroup().isEmpty()) {
                    List group = groups.computeIfAbsent(recipe.getGroup(), k -> Lists.newArrayList());
                    group.add(recipe);
                    continue;
                }
                leftovers.add(recipe);
            }
            registry.addRecipes(TRANSMUTATION, groups.values().stream().map(list -> list.stream().filter(it -> !it.output.isEmpty() && !it.ingredient.isEmpty()).collect(Collectors.toList())).map(SpiritTransmutationWrapper::new).collect(Collectors.toList()));
            registry.addRecipes(TRANSMUTATION, leftovers.stream().filter(it -> !it.output.isEmpty() && !it.ingredient.isEmpty()).map(r -> new SpiritTransmutationWrapper(List.of(r))).collect(Collectors.toList()));
            registry.addRecipes(FOCUSING, LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.SPIRIT_FOCUSING.get())).stream().filter(it -> !it.output.isEmpty()).collect(Collectors.toList()));
            registry.addRecipes(SPIRIT_REPAIR, LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get())).stream().filter(it -> !it.validItems.isEmpty()).collect(Collectors.toList()));
            registry.addRecipes(WEEPING_WELL, LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.VOID_FAVOR.get())).stream().filter(it -> !it.result.isEmpty()).collect(Collectors.toList()));
            registry.addRecipes(RUNEWORKING, LodestoneRecipeType.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MalumRecipeTypes.RUNEWORKING.get())).stream().filter(it -> !it.output.isEmpty()).collect(Collectors.toList()));
            if (FarmersDelightCompat.LOADED) {
                FarmersDelightCompat.AndJeiLoadedOnly.addInfo(registry);
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.SPIRIT_ALTAR.get()), new RecipeType[]{SPIRIT_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.SPIRIT_CRUCIBLE.get()), new RecipeType[]{FOCUSING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.REPAIR_PYLON.get()), new RecipeType[]{SPIRIT_REPAIR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.SOULWOOD_TOTEM_BASE.get()), new RecipeType[]{TRANSMUTATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.RUNIC_WORKBENCH.get()), new RecipeType[]{RUNEWORKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)MalumItems.VOID_DEPOT.get()), new RecipeType[]{WEEPING_WELL});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        CALLBACKS.add(HiddenTagHandler.registerHiddenItemListener(() -> {
            List<TagKey<Item>> tagsToHide = HiddenTagHandler.getTagsToHide();
            this.hideItems(jeiRuntime, tagsToHide);
            this.hideRecipes(jeiRuntime, tagsToHide);
        }));
    }

    public void onRuntimeUnavailable() {
        CALLBACKS.forEach(HiddenTagHandler::removeListener);
        CALLBACKS.clear();
        HIDDEN_RECIPE_SETS.clear();
        HIDDEN_ITEMS.clear();
    }

    public void hideItems(IJeiRuntime jeiRuntime, List<TagKey<Item>> tagsToHide) {
        if (!((Boolean)CommonConfig.HIDE_RECIPES.getConfigValue()).booleanValue()) {
            return;
        }
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        if (!HIDDEN_ITEMS.isEmpty()) {
            ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, HIDDEN_ITEMS);
            HIDDEN_ITEMS.clear();
        }
        if (!tagsToHide.isEmpty()) {
            Collection ingredients = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
            for (ItemStack stack : ingredients) {
                if (!HiddenTagHandler.isHiddenItem(stack)) continue;
                HIDDEN_ITEMS.add(stack);
            }
            if (!HIDDEN_ITEMS.isEmpty()) {
                ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, HIDDEN_ITEMS);
            }
        }
    }

    public void hideRecipes(IJeiRuntime jeiRuntime, List<TagKey<Item>> tagsToHide) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        IJeiHelpers helpers = jeiRuntime.getJeiHelpers();
        IFocusFactory focusFactory = helpers.getFocusFactory();
        helpers.getAllRecipeTypes().forEach(it -> {
            HiddenRecipeSet hiddenRecipes = HIDDEN_RECIPE_SETS.computeIfAbsent((RecipeType<?>)it, HiddenRecipeSet::createSet);
            hiddenRecipes.unhidePreviouslyHiddenRecipes(recipeRegistry);
            if (!tagsToHide.isEmpty()) {
                hiddenRecipes.scanAndHideRecipes(recipeRegistry, focusFactory, tagsToHide);
            }
        });
    }
}

