/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.sacred;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.level.block.Blocks;

public interface NurturingEffectActor<T extends Mob> {
    public static final NurturingEffectActor<Sheep> SHEEP = new NurturingEffectActor<Sheep>(){

        @Override
        public boolean act(ServerLevel level, Sheep sheep) {
            BlockPos pos;
            if (sheep.getRandom().nextFloat() < 0.6f && (EatBlockGoal.IS_TALL_GRASS.test(level.getBlockState(pos = sheep.blockPosition())) || level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK))) {
                EatBlockGoal goal = sheep.eatBlockGoal;
                goal.start();
                return true;
            }
            return false;
        }

        @Override
        public Class<Sheep> getTargetClass() {
            return Sheep.class;
        }
    };
    public static final NurturingEffectActor<Bee> BEE = new NurturingEffectActor<Bee>(){

        @Override
        public boolean act(ServerLevel level, Bee bee) {
            Bee.BeePollinateGoal goal = bee.beePollinateGoal;
            if (goal.canBeeUse()) {
                goal.successfulPollinatingTicks += 40;
                goal.tick();
                return true;
            }
            return false;
        }

        @Override
        public Class<Bee> getTargetClass() {
            return Bee.class;
        }
    };
    public static final NurturingEffectActor<Chicken> CHICKEN = new NurturingEffectActor<Chicken>(){

        @Override
        public boolean act(ServerLevel level, Chicken chicken) {
            chicken.eggTime -= 80;
            return true;
        }

        @Override
        public Class<Chicken> getTargetClass() {
            return Chicken.class;
        }
    };
    public static final NurturingEffectActor<Allay> ALLAY = new NurturingEffectActor<Allay>(){

        @Override
        public boolean act(ServerLevel level, Allay allay) {
            allay.duplicationCooldown -= 80L;
            return true;
        }

        @Override
        public Class<Allay> getTargetClass() {
            return Allay.class;
        }
    };

    default public boolean tryAct(ServerLevel level, LivingEntity target) {
        if (this.getTargetClass().isInstance(target)) {
            return this.act(level, (Mob)target);
        }
        return false;
    }

    public boolean act(ServerLevel var1, T var2);

    public Class<T> getTargetClass();
}

