/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.infernal;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockSmeltingRiteEffect
extends SpiritRiteBlockEffect {
    public BlockSmeltingRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        SmeltingRecipe recipe;
        ItemStack output;
        Item item;
        Optional recipeOptional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(new ItemStack((ItemLike)state.getBlock().asItem(), 1)), (Level)level);
        if (recipeOptional.isPresent() && (item = (output = (recipe = (SmeltingRecipe)((RecipeHolder)recipeOptional.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess())).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockState newState = block.defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            level.levelEvent(2001, pos, Block.getId((BlockState)newState));
            this.createEffect(level, pos, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT);
        }
    }
}

