/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.sound;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

public class RareEarthSoundType
extends ExtendedSoundType {
    public RareEarthSoundType(float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        super(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
    }

    public void onPlayBreakSound(Level level, BlockPos pos) {
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)MalumSoundEvents.CTHONIC_GOLD_BREAK.get(), SoundSource.BLOCKS, (this.getVolume() + 1.0f) / 2.0f, this.getPitch() - level.random.nextFloat() * 0.4f, false);
    }

    public void onPlayPlaceSound(Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, (SoundEvent)MalumSoundEvents.CTHONIC_GOLD_PLACE.get(), SoundSource.BLOCKS, (this.getVolume() + 2.0f) / 2.0f, this.getPitch() - level.random.nextFloat() * 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayHitSound(BlockPos pos) {
        MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
        if (gameMode != null) {
            float progress = gameMode.destroyProgress;
            float volume = (this.getVolume() + progress * progress * 4.0f) / 8.0f;
            float pitch = this.getPitch() * (0.5f + 0.15f * progress);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)MalumSoundEvents.QUARTZ_ORE_HIT.get(), SoundSource.BLOCKS, volume, pitch, MalumMod.RANDOM, pos));
        }
    }
}

