/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.spirit_repair;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.data.map.ImpetusDataMap;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRegexData;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.MalumDataMaps;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SpiritRepairRecipe
extends LodestoneInWorldRecipe<SpiritBasedRecipeInput> {
    public static final MapCodec<SpiritRepairRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)BuiltInRegistries.ITEM.holderByNameCodec().listOf().fieldOf("validItems").forGetter(recipe -> recipe.validItems), (App)SpiritIngredient.CODEC.codec().listOf().fieldOf("spirits").forGetter(recipe -> recipe.spirits), (App)SizedIngredient.FLAT_CODEC.fieldOf("repairMaterial").forGetter(recipe -> recipe.repairMaterial), (App)Codec.FLOAT.optionalFieldOf("durabilityPercentage", (Object)Float.valueOf(0.5f)).forGetter(recipe -> Float.valueOf(recipe.repairEfficiency)), (App)SpiritRepairRegexData.CODEC.optionalFieldOf("regex", (Object)SpiritRepairRegexData.EMPTY).forGetter(recipe -> recipe.regex)).apply((Applicative)obj, SpiritRepairRecipe::new));
    public static final String NAME = "spirit_repair";
    public final List<Holder<Item>> validItems;
    public final List<SpiritIngredient> spirits;
    public final SizedIngredient repairMaterial;
    public final float repairEfficiency;
    public final SpiritRepairRegexData regex;

    public SpiritRepairRecipe(List<Holder<Item>> validItems, List<SpiritIngredient> spirits, SizedIngredient repairMaterial, float repairEfficiency, SpiritRepairRegexData regex) {
        super((RecipeSerializer)MalumRecipeSerializers.REPAIR_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get());
        this.validItems = regex.isEmpty() ? validItems : regex.modifyRepairInput(validItems);
        this.spirits = spirits;
        this.repairMaterial = repairMaterial;
        this.repairEfficiency = repairEfficiency;
        this.regex = regex;
    }

    public boolean isValidItemForRepair(ItemLike input) {
        for (Holder<Item> validItem : this.validItems) {
            if (!((Item)validItem.value()).equals(input)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getResultItem(ItemStack input) {
        Holder holder = input.getItemHolder();
        ImpetusDataMap data = (ImpetusDataMap)holder.getData(MalumDataMaps.REPAIRED_IMPETUS_VARIANT);
        if (data != null) {
            Item otherImpetus = (Item)data.otherImpetus().value();
            return otherImpetus.getDefaultInstance();
        }
        ItemStack output = input.copy();
        output.setDamageValue(Math.max(0, input.getDamageValue() - (int)((float)output.getMaxDamage() * this.repairEfficiency)));
        return output;
    }

    public List<ItemStack> getRepairedItems() {
        ArrayList<ItemStack> repairedItems = new ArrayList<ItemStack>();
        for (Holder<Item> holder : this.validItems) {
            Item item = (Item)holder.value();
            ItemStack input = item.getDefaultInstance();
            repairedItems.add(this.getResultItem(input));
        }
        return repairedItems;
    }

    public List<ItemStack> getDamagedItems() {
        ArrayList<ItemStack> damagedItems = new ArrayList<ItemStack>();
        for (Holder<Item> holder : this.validItems) {
            Item item = (Item)holder.value();
            ItemStack input = item.getDefaultInstance();
            input.setDamageValue((int)((float)input.getMaxDamage() * this.repairEfficiency));
            damagedItems.add(input);
        }
        return damagedItems;
    }

    public boolean matches(SpiritBasedRecipeInput input, Level level) {
        return input.test(this.repairMaterial, this.spirits);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(SpiritBasedRecipeInput input, ItemStack repairTarget) {
        if (!input.test(this.repairMaterial, this.spirits)) return false;
        if (!this.validItems.stream().anyMatch(arg_0 -> ((ItemStack)repairTarget).is(arg_0))) return false;
        return true;
    }

    public final ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.repairMaterial.getItems()[0];
    }
}

