/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.payloads.waveform;

import com.sammy.malum.common.block.curiosities.redstone.OpenStateBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;

public abstract class OpenBlockEntityStateUpdatePayload<T extends OpenStateBlockEntity.InboundInfo<?>>
extends OneSidedPayloadData {
    private final BlockPos pos;
    private final boolean isOpen;
    private final T info;

    public OpenBlockEntityStateUpdatePayload(BlockPos pos, boolean isOpen, T info) {
        this.pos = pos;
        this.isOpen = isOpen;
        this.info = info;
    }

    public OpenBlockEntityStateUpdatePayload(FriendlyByteBuf buf) {
        this.pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
        this.isOpen = buf.readBoolean();
        this.info = (OpenStateBlockEntity.InboundInfo)this.getInfoCodec().decode((Object)buf);
    }

    public abstract StreamCodec<ByteBuf, T> getInfoCodec();

    public void handle(IPayloadContext iPayloadContext) {
        ServerLevel level;
        BlockEntity blockEntity;
        Level level2 = iPayloadContext.player().level();
        if (level2 instanceof ServerLevel && (blockEntity = (level = (ServerLevel)level2).getBlockEntity(this.pos)) instanceof OpenStateBlockEntity) {
            OpenStateBlockEntity openStateBlockEntity = (OpenStateBlockEntity)blockEntity;
            openStateBlockEntity.toggleState(level, this.isOpen, (OpenStateBlockEntity.InboundInfo<?>)this.info);
        }
    }

    public void serialize(FriendlyByteBuf buf) {
        BlockPos.STREAM_CODEC.encode((Object)buf, (Object)this.pos);
        buf.writeBoolean(this.isOpen);
        this.getInfoCodec().encode((Object)buf, this.info);
    }
}

