/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.tools.spellweaver;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.component.SpellweavingToolStateComponent;
import com.sammy.malum.common.entity.activator.SpellweaverToolEffectActivatorEntity;
import com.sammy.malum.common.item.curiosities.tools.spellweaver.ISpellweavingTool;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.listeners.SpellweavingEqualityReloadListener;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.enchantment.ModEnchantmentComponents;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IAttributeExtension;
import net.neoforged.neoforge.event.level.BlockEvent;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.enchanting.LodestoneEnchantmentEffectActivator;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.item.tools.magic.MagicPickaxeItem;

public class SpellweavingPickaxeItem
extends MagicPickaxeItem
implements ISpiritAffiliatedItem,
ISpellweavingTool {
    public static final ResourceLocation BASE_INTERACTION_RANGE = MalumMod.malumPath("spellweaving_tool.base_block_interaction_range");

    public SpellweavingPickaxeItem(Tier tier, float attackDamage, float attackSpeed, float magicDamage, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, magicDamage, properties.mergeAttributes(ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(BASE_INTERACTION_RANGE, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public static ResourceLocation getBaseId(IAttributeExtension attribute) {
        if (attribute.equals(Attributes.BLOCK_INTERACTION_RANGE.value())) {
            return BASE_INTERACTION_RANGE;
        }
        return null;
    }

    @Override
    public SpiritLike getDefiningSpiritType() {
        return MalumSpiritTypes.EARTHEN_SPIRIT;
    }

    @Override
    public ISpellweavingTool.Mode getMode() {
        return ISpellweavingTool.Mode.NEAREST;
    }

    public static int getStateDisplay(ItemStack stack) {
        SpellweavingToolStateComponent data = (SpellweavingToolStateComponent)stack.get(MalumDataComponents.SPELLWEAVING_TOOL_STATE);
        if (data == null) {
            return -1;
        }
        return data.isPrimed() ? 1 : -1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (SpellweavingPickaxeItem.toggleState(player, usedHand)) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        SpellweavingPickaxeItem.inventoryTick(pStack, pEntity, pIsSelected);
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public static void triggerSpellweavingEffect(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        ItemStack tool = player.getMainHandItem();
        Item item = tool.getItem();
        if (!(item instanceof ISpellweavingTool)) {
            return;
        }
        ISpellweavingTool spellweavingTool = (ISpellweavingTool)item;
        SpellweavingToolStateComponent component = (SpellweavingToolStateComponent)tool.get(MalumDataComponents.SPELLWEAVING_TOOL_STATE);
        if (component != null && component.isPrimed()) {
            SpiritLike spiritLike;
            int startingIndex;
            int travelTokens;
            BlockState state = event.getState();
            if (!SpellweavingPickaxeItem.matches(state, tool)) {
                return;
            }
            RandomSource random = player.getRandom();
            BlockPos pos = event.getPos();
            Direction primaryDirection = Direction.orderedByNearest((Entity)player)[0];
            Direction[] directionOrder = SpellweavingPickaxeItem.getDirectionOrder(player);
            LinkedHashMultimap nearbyBlocks = LinkedHashMultimap.create();
            BlockPos.MutableBlockPos mutable = event.getPos().mutable();
            HashSet exploredBlocks = Sets.newHashSet();
            HashSet<BlockPos> currentLayer = Sets.newHashSet();
            HashSet nextLayer = Sets.newHashSet();
            currentLayer.add(mutable.immutable());
            for (travelTokens = startingIndex = 16; travelTokens > 0; --travelTokens) {
                for (BlockPos blockPos2 : currentLayer) {
                    for (Direction direction : directionOrder) {
                        mutable.setWithOffset((Vec3i)blockPos2, direction);
                        SpellweavingPickaxeItem.propagate(level, blockPos2, exploredBlocks, mutable, nextLayer, state);
                    }
                    if (nextLayer.isEmpty()) {
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && y == 0 && z == 0) continue;
                                    mutable.set((Vec3i)blockPos2).move(x, y, z);
                                    SpellweavingPickaxeItem.propagate(level, blockPos2, exploredBlocks, mutable, nextLayer, state);
                                }
                            }
                        }
                    }
                    currentLayer = new HashSet<BlockPos>(nextLayer);
                }
                if (nextLayer.isEmpty()) break;
                ArrayList<BlockPos> toAdd = new ArrayList<BlockPos>(nextLayer);
                toAdd.sort(Comparator.comparingDouble(blockPos -> blockPos.getCenter().distanceTo(player.getEyePosition())));
                for (BlockPos markedPos3 : toAdd) {
                    nearbyBlocks.put((Object)travelTokens, (Object)markedPos3);
                }
                nextLayer.clear();
            }
            if (nearbyBlocks.isEmpty()) {
                return;
            }
            boolean isNearest = spellweavingTool.getMode().equals((Object)ISpellweavingTool.Mode.NEAREST);
            Item y = tool.getItem();
            if (y instanceof ISpiritAffiliatedItem) {
                ISpiritAffiliatedItem spiritItem = (ISpiritAffiliatedItem)y;
                spiritLike = spiritItem.getDefiningSpiritType();
            } else {
                spiritLike = MalumSpiritTypes.ARCANE_SPIRIT;
            }
            SpiritHolder<SpiritArcanaType> spiritHolder = spiritLike;
            int spawnedLoci = SpellweavingPickaxeItem.getSpawnedLoci(level, tool, player);
            float lociSpeed = SpellweavingPickaxeItem.getLociSpeed(level, tool, player);
            int finalTravelTokens = travelTokens;
            List<BlockPos> backup = IntStream.range(0, startingIndex / 2).map(i -> finalTravelTokens + i).mapToObj(arg_0 -> ((Multimap)nearbyBlocks).get(arg_0)).flatMap(Collection::stream).toList();
            boolean disallowBeneath = (double)pos.getY() >= player.getY() && primaryDirection.getAxis().isHorizontal() && isNearest;
            boolean playSound = false;
            int distance = spawnedLoci + 1;
            for (int i2 = 0; i2 < distance * 2; ++i2) {
                int offset = i2 % distance;
                int index = isNearest ? startingIndex - offset : travelTokens + 1 + offset;
                Collection blocks = nearbyBlocks.get((Object)index);
                if (!blocks.isEmpty()) {
                    ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
                    for (BlockPos markedPos : blocks) {
                        if (disallowBeneath && (double)markedPos.getY() < player.getY()) continue;
                        if (spawnedLoci <= 0) break;
                        SpellweavingPickaxeItem.spawnBreaker(level, markedPos, random, tool, player, lociSpeed, pos, spiritHolder, backup);
                        toRemove.add(markedPos);
                        playSound = true;
                        --spawnedLoci;
                    }
                    blocks.removeAll(toRemove);
                    toRemove.clear();
                }
                if (i2 != distance) continue;
                if (!disallowBeneath) break;
                disallowBeneath = false;
            }
            if (playSound) {
                SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.SPELLWOVEN_SPRITE_SPAWN.get()), (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void propagate(ServerLevel level, BlockPos markedPos, Set<BlockPos> exploredBlocks, BlockPos.MutableBlockPos mutable, Set<BlockPos> nextLayer, BlockState state) {
        BlockState markedState;
        if (!exploredBlocks.contains(mutable) && !nextLayer.contains(mutable) && SpellweavingPickaxeItem.matches(state, markedState = level.getBlockState((BlockPos)mutable))) {
            BlockPos immutable = mutable.immutable();
            exploredBlocks.add(markedPos);
            nextLayer.add(immutable);
        }
    }

    private static void spawnBreaker(ServerLevel level, BlockPos markedPos, RandomSource random, ItemStack tool, Player player, float lociSpeed, BlockPos pos, SpiritLike spirit, List<BlockPos> backup) {
        float velocity = 0.35f;
        Vec3 velocityVector = new Vec3((double)RandomHelper.randomBetween((RandomSource)random, (float)(-velocity), (float)velocity), (double)RandomHelper.randomBetween((RandomSource)random, (float)(-velocity), (float)velocity), (double)RandomHelper.randomBetween((RandomSource)random, (float)(-velocity), (float)velocity));
        SpellweaverToolEffectActivatorEntity breaker = new SpellweaverToolEffectActivatorEntity((Level)level, tool, player.getUUID(), lociSpeed, markedPos, pos.getCenter(), velocityVector);
        breaker.setSpirit(spirit.getSpirit());
        breaker.addBackupPositions(backup);
        level.addFreshEntity((Entity)breaker);
    }

    public static boolean toggleState(Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        SpellweavingToolStateComponent component = (SpellweavingToolStateComponent)stack.getOrDefault(MalumDataComponents.SPELLWEAVING_TOOL_STATE, (Object)new SpellweavingToolStateComponent());
        boolean isPrimed = component.isPrimed();
        SoundEvent sound = isPrimed ? (SoundEvent)MalumSoundEvents.SPELLWEAVING_TOOL_DAMPEN.get() : (SoundEvent)MalumSoundEvents.SPELLWEAVING_TOOL_PRIME.get();
        stack.set(MalumDataComponents.SPELLWEAVING_TOOL_STATE, (Object)new SpellweavingToolStateComponent(!isPrimed, 0));
        SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)1.0f, (float)1.0f);
        player.swing(usedHand, true);
        ItemCooldowns cooldowns = player.getCooldowns();
        boolean wasOnCooldown = cooldowns.isOnCooldown(stack.getItem());
        cooldowns.addCooldown(stack.getItem(), 8);
        return !wasOnCooldown;
    }

    public static void inventoryTick(ItemStack stack, Entity entity, boolean isSelected) {
        SpellweavingToolStateComponent data = (SpellweavingToolStateComponent)stack.get(MalumDataComponents.SPELLWEAVING_TOOL_STATE);
        if (data != null) {
            boolean isPrimed = data.isPrimed();
            if (!isPrimed) {
                return;
            }
            int timer = data.timer();
            int n = timer = isSelected ? 0 : timer + 1;
            if (timer >= 40) {
                timer = 0;
                isPrimed = false;
                SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.SPELLWEAVING_TOOL_DAMPEN.get()), (float)1.0f, (float)1.0f);
            }
            stack.set(MalumDataComponents.SPELLWEAVING_TOOL_STATE, (Object)new SpellweavingToolStateComponent(isPrimed, timer));
        }
    }

    public static int getSpawnedLoci(ServerLevel level, ItemStack stack, Player player) {
        float spawnedLoci = 4.0f + LodestoneEnchantmentEffectActivator.createEffectActivator(ModEnchantmentComponents.LOCUS_COUNT.get(), (ServerLevel)level).setItemContext(stack).countValue(stack, (Entity)player);
        return Mth.floor((float)spawnedLoci);
    }

    public static float getLociSpeed(ServerLevel level, ItemStack stack, Player player) {
        return 0.5f + LodestoneEnchantmentEffectActivator.createEffectActivator(ModEnchantmentComponents.LOCUS_SPEED.get(), (ServerLevel)level).setItemContext(stack).countValue(stack, (Entity)player);
    }

    public static Direction[] getDirectionOrder(Player player) {
        Direction[] lookDirection = Direction.orderedByNearest((Entity)player);
        return new Direction[]{lookDirection[1], lookDirection[2], lookDirection[3], lookDirection[4], lookDirection[0], lookDirection[5]};
    }

    public static boolean matches(BlockState state, ItemStack tool) {
        Tool toolProperties = (Tool)tool.get(DataComponents.TOOL);
        if (toolProperties == null) {
            return false;
        }
        for (Tool.Rule tool$rule : toolProperties.rules()) {
            if (!state.is(tool$rule.blocks())) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(BlockState first, BlockState second) {
        if (second.isEmpty()) {
            return false;
        }
        List<SpellweavingEqualityReloadListener.SpellweavingEqualityData> data = SpellweavingEqualityReloadListener.EQUALITY_DATA;
        for (SpellweavingEqualityReloadListener.SpellweavingEqualityData datum : data) {
            List<Holder<Block>> equalBlocks = datum.equalBlocks();
            Holder firstHolder = first.getBlockHolder();
            Holder secondHolder = second.getBlockHolder();
            if (!equalBlocks.contains(firstHolder) || !equalBlocks.contains(secondHolder)) continue;
            return true;
        }
        return first.getBlock().equals(second.getBlock());
    }
}

