/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.tools.spellweaver;

import com.sammy.malum.common.item.curiosities.tools.spellweaver.ISpellweavingTool;
import com.sammy.malum.common.item.curiosities.tools.spellweaver.SpellweavingPickaxeItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.item.tools.magic.MagicAxeItem;

public class SpellweavingAxeItem
extends MagicAxeItem
implements ISpiritAffiliatedItem,
ISpellweavingTool {
    public SpellweavingAxeItem(Tier tier, float attackDamage, float attackSpeed, float magicDamage, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, magicDamage, properties.mergeAttributes(ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(SpellweavingPickaxeItem.BASE_INTERACTION_RANGE, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    @Override
    public SpiritLike getDefiningSpiritType() {
        return MalumSpiritTypes.AQUEOUS_SPIRIT;
    }

    @Override
    public ISpellweavingTool.Mode getMode() {
        return ISpellweavingTool.Mode.FURTHEST;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (SpellweavingPickaxeItem.toggleState(player, usedHand)) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        SpellweavingPickaxeItem.inventoryTick(pStack, pEntity, pIsSelected);
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }
}

