/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.scythe;

import com.sammy.malum.common.entity.scythe.AbstractScytheProjectileEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumDamageTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class CurioHowlingMaelstromRing
extends MalumCurioItem
implements IMalumEventResponder {
    public CurioHowlingMaelstromRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("rebound_maelstrom", new Object[0]));
        consumer.accept(ComponentHelper.negativeCurioEffect("longer_rebound_cooldown", new Object[0]));
    }

    public static void handleMaelstrom(ServerLevel serverLevel, LivingEntity scytheOwner, AbstractScytheProjectileEntity entity) {
        if (serverLevel.getGameTime() % 5L == 0L) {
            boolean dealtDamage = false;
            AABB aabb = entity.getBoundingBox().inflate(2.0);
            float damage = entity.damage * 0.2f;
            float magicDamage = entity.magicDamage * 0.2f;
            for (Entity target : serverLevel.getEntities((Entity)entity, aabb, t -> CurioHowlingMaelstromRing.maelstromCanHitEntity(scytheOwner, t))) {
                DamageSource damageSource = DamageTypeHelper.create((Level)serverLevel, MalumDamageTypes.SCYTHE_MAELSTROM, (Entity)entity, (Entity)scytheOwner);
                target.invulnerableTime = 0;
                boolean success = target.hurt(damageSource, damage);
                if (!success || !(target instanceof LivingEntity)) continue;
                LivingEntity livingentity = (LivingEntity)target;
                if (entity.magicDamage > 0.0f && !livingentity.isDeadOrDying()) {
                    livingentity.invulnerableTime = 0;
                    livingentity.hurt(DamageTypeHelper.create((Level)serverLevel, MalumDamageTypes.VOODOO, (Entity)entity, (Entity)scytheOwner), magicDamage);
                }
                dealtDamage = true;
            }
            if (dealtDamage) {
                ++entity.returnTimer;
                entity.setDeltaMovement(entity.getDeltaMovement().scale((double)0.7f));
            }
        }
    }

    protected static boolean maelstromCanHitEntity(LivingEntity scytheOwner, Entity pTarget) {
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        return pTarget != scytheOwner && !scytheOwner.isPassengerOfSameVehicle(pTarget);
    }
}

