/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.wicked;

import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class ReaperGeas
extends GeasEffect {
    public ReaperGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_REAPER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("scythe_combo", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("only_scythe", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            ItemStack heldItem = attacker.getMainHandItem();
            if (source.is(DamageTypes.PLAYER_ATTACK) || source.is(MalumDamageTypes.TYRVING)) {
                if (!heldItem.isEmpty()) {
                    event.setNewDamage(event.getNewDamage() * 0.1f);
                    if (heldItem.isDamageableItem()) {
                        heldItem.hurtAndBreak(10, attacker, EquipmentSlot.MAINHAND);
                    }
                }
                return;
            }
            if (source.is(MalumTags.DamageTypeTags.TRIGGERS_SCYTHE_COMBO)) {
                MalumScytheItem.ScytheDamage damage = MalumScytheItem.getScytheDamage(source, attacker);
                float physicalDamage = damage.physicalDamage();
                float magicDamage = damage.magicDamage();
                float damageScalar = 0.1f;
                float chance = 0.3f;
                int extraHits = 2;
                if (damage.isBoomerang()) {
                    chance *= 2.0f;
                }
                float average = (physicalDamage + magicDamage) / 2.0f;
                physicalDamage *= physicalDamage / average * damageScalar;
                magicDamage *= magicDamage / average * damageScalar;
                if (MalumScytheItem.isEnhanced(attacker)) {
                    ++extraHits;
                    chance += 0.1f;
                }
                if (attacker.getRandom().nextFloat() < chance) {
                    for (int i = 0; i < extraHits; ++i) {
                        int delay = 4 + i * 3;
                        WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker, source.getDirectEntity()).setDamageData(physicalDamage, magicDamage, delay).setPhysicalDamageType(MalumDamageTypes.SCYTHE_COMBO).setSound((Holder<SoundEvent>)MalumSoundEvents.REAPER_CUT, 0.9f, 1.1f, 1.0f));
                    }
                }
            }
        }
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            RandomSource random = attacker.getRandom();
            DamageSource source = event.getSource();
            if (source.is(MalumDamageTypes.SCYTHE_COMBO)) {
                ItemStack scytheStack = SoulDataHandler.getScytheWeapon(source, attacker);
                WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).tiedToTarget().forwardOffset(-2.0f).upwardOffset(-0.5f).color(scytheStack.getItem()).mirroredRandomly(random);
                if (MalumScytheItem.canSweep(attacker)) {
                    MalumScytheItem.trySweep(attacker, target, event.getNewDamage());
                } else {
                    particle.verticalSlashRotation();
                }
                particle.slashRotation(particle.getSlashRotation() + RandomHelper.randomBetween((RandomSource)random, (float)-0.3f, (float)0.3f));
                particle.spawn(level2);
            }
        }
    }
}

