/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.earthen;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class ContentednessGeas
extends GeasEffect {
    private int foodLevel = 20;

    public ContentednessGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_CONTENTEDNESS.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("high_hunger_more_armor", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("low_hunger_less_armor", new Object[0]));
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        float multiplier;
        float f = multiplier = this.foodLevel >= 10 ? 0.2f : -0.5f;
        if (this.foodLevel > 6 && this.foodLevel < 14) {
            multiplier = 0.0f;
        }
        this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR, multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int oldFoodLevel = this.foodLevel;
            this.foodLevel = player.getFoodData().getFoodLevel();
            if (oldFoodLevel != this.foodLevel) {
                this.setDirty();
            }
        }
    }
}

