/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aqueous;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class HighPriestGeas
extends GeasEffect {
    private static final int COOLDOWN_DURATION = 600;
    public boolean isActive = false;

    public HighPriestGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_HIGH_PRIEST.get());
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.isActive) {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 0.5, AttributeModifier.Operation.ADD_VALUE);
            this.addAttributeModifier(modifiers, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 2.0, AttributeModifier.Operation.ADD_VALUE);
        }
        return modifiers;
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("bonus_reach", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("fragile_reach", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("fragile_reach_slowdown", new Object[0]));
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        boolean hasEffect = entity.hasEffect(MalumMobEffects.SHAKEN_FAITH);
        if (this.isActive == hasEffect) {
            this.isActive = !this.isActive;
            this.setDirty();
        }
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            if (source.getDirectEntity() != null && source.getEntity() != null && !this.isActive) {
                return;
            }
            MalumParticleEffectTypes.HIGH_PRIEST_PENANCE.createEffect((Entity)target).color(new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT)).spawn(level2);
            target.addEffect(new MobEffectInstance(MalumMobEffects.SHAKEN_FAITH, 600, 0, true, true, true));
        }
    }
}

