/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.aerial;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

public class SkyBreakerGeas
extends GeasEffect {
    private final ArrayList<LivingEntity> cachedTargets = new ArrayList();

    public SkyBreakerGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_SKYBREAKER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("incoming_fall_damage_auto_attack", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("outgoing_fall_damage_auto_attack", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("more_knockback", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public static void scaleKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        GeasEffect geas = GeasEffectHandler.getGeasEffect(entity, MalumGeasEffectTypes.PACT_OF_THE_SKYBREAKER);
        if (geas != null) {
            event.setStrength(event.getStrength() * 3.0f);
        }
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (event.getSource().is(DamageTypes.FALL)) {
                this.attack(player, (Entity)target);
            }
        }
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            if (event.getSource().is(DamageTypes.FALL)) {
                AABB aabb = player.getBoundingBox().inflate(4.0, 1.0, 4.0);
                this.cachedTargets.clear();
                for (Entity nearbyTarget : player.serverLevel().getEntities((Entity)player, aabb, t -> SkyBreakerGeas.skyBreakerCanHitEntity((Player)player, t))) {
                    if (!(nearbyTarget instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)nearbyTarget;
                    this.cachedTargets.add(living);
                    event.setNewDamage(event.getNewDamage() * 0.8f);
                }
            }
        }
    }

    public void finalizedIncomingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            if (event.getSource().is(DamageTypes.FALL)) {
                for (LivingEntity cachedTarget : this.cachedTargets) {
                    if (!cachedTarget.isAlive()) continue;
                    this.attack((Player)player, (Entity)cachedTarget);
                }
            }
        }
    }

    public void attack(Player player, Entity target) {
        if (target.isAlive()) {
            player.attackStrengthTicker = 1000;
            player.swing(InteractionHand.MAIN_HAND, true);
            target.invulnerableTime = 0;
            player.attack(target);
            target.invulnerableTime = 0;
        }
    }

    protected static boolean skyBreakerCanHitEntity(Player attacker, Entity pTarget) {
        TamableAnimal tamableAnimal;
        if (pTarget instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pTarget).isTame()) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        return pTarget != attacker && !attacker.isPassengerOfSameVehicle(pTarget);
    }
}

