/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.scythe;

import com.sammy.malum.common.entity.scythe.AbstractScytheProjectileEntity;
import com.sammy.malum.common.entity.scythe.LocalizedMaelstromEntity;
import com.sammy.malum.common.item.curiosities.curios.sets.scythe.CurioHowlingMaelstromRing;
import com.sammy.malum.core.handlers.enchantment.ReboundHandler;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ScytheBoomerangEntity
extends AbstractScytheProjectileEntity {
    private static final EntityDataAccessor<Boolean> DATA_NARROW = SynchedEntityData.defineId(ScytheBoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_MAELSTROM = SynchedEntityData.defineId(ScytheBoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final TrailPointBuilder theFormer = TrailPointBuilder.create((int)8);
    public final TrailPointBuilder theLatter = TrailPointBuilder.create((int)8);

    public ScytheBoomerangEntity(Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)MalumEntities.SCYTHE_BOOMERANG.get()), level);
    }

    public ScytheBoomerangEntity(Level level, double pX, double pY, double pZ) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)MalumEntities.SCYTHE_BOOMERANG.get()), pX, pY, pZ, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_NARROW, (Object)false);
        builder.define(DATA_MAELSTROM, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("isNarrow", this.isNarrow());
        compound.putBoolean("isMaelstrom", this.isMaelstrom());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setNarrow(compound.getBoolean("isNarrow"));
        this.setMaelstrom(compound.getBoolean("isMaelstrom"));
    }

    public void setNarrow(boolean setNarrow) {
        this.getEntityData().set(DATA_NARROW, (Object)setNarrow);
    }

    public boolean isNarrow() {
        return (Boolean)this.getEntityData().get(DATA_NARROW);
    }

    public void setMaelstrom(boolean maelstrom) {
        this.getEntityData().set(DATA_MAELSTROM, (Object)maelstrom);
    }

    public boolean isMaelstrom() {
        return (Boolean)this.getEntityData().get(DATA_MAELSTROM);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.returnTimer = 0;
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity scytheOwner = (LivingEntity)entity;
            this.flyBack((Entity)scytheOwner);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (this.isNarrow()) {
            Entity entity;
            if (this.isMaelstrom() && this.returnTimer > 0) {
                Entity target = result.getEntity();
                LocalizedMaelstromEntity maelstrom = new LocalizedMaelstromEntity(this.level(), target.getX(), target.getY() + (double)(target.getBbHeight() * 0.75f), target.getZ());
                maelstrom.setData(this.getOwner(), this.damage, this.magicDamage, 0, 40);
                maelstrom.setItem(this.getItem());
                this.level().addFreshEntity((Entity)maelstrom);
                this.returnTimer = 0;
            }
            if ((entity = this.getOwner()) instanceof LivingEntity) {
                LivingEntity scytheOwner = (LivingEntity)entity;
                this.flyBack((Entity)scytheOwner);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        ItemStack scythe = this.getItem();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity owner = this.getOwner();
            if (owner == null || !owner.isAlive() || !owner.level().equals(this.level()) || this.distanceTo(owner) > 1000.0f) {
                this.setDeltaMovement(Vec3.ZERO);
                return;
            }
            if (owner instanceof LivingEntity) {
                LivingEntity scytheOwner = (LivingEntity)owner;
                if (this.isMaelstrom() && !this.isNarrow()) {
                    CurioHowlingMaelstromRing.handleMaelstrom(serverLevel, scytheOwner, this);
                }
                this.playSound();
                --this.returnTimer;
                if (this.returnTimer <= 0) {
                    Vec3 ownerPos = scytheOwner.position().add(0.0, (double)(scytheOwner.getBbHeight() * 0.6f), 0.0);
                    float velocityLimit = 2.0f;
                    if (this.isNarrow()) {
                        double radians = Math.toRadians(90.0f - scytheOwner.yHeadRot);
                        ownerPos = scytheOwner.position().add(0.75 * Math.sin(radians), (double)(scytheOwner.getBbHeight() * 0.5f), 0.75 * Math.cos(radians));
                        velocityLimit = 4.0f;
                        if (this.returnTimer == 0) {
                            this.flyBack((Entity)scytheOwner);
                        }
                    }
                    if (this.isMaelstrom()) {
                        velocityLimit -= 1.25f;
                    }
                    Vec3 motion = this.getDeltaMovement();
                    double velocity = Mth.clamp((double)(motion.length() * 3.0), (double)0.5, (double)velocityLimit);
                    Vec3 returnMotion = ownerPos.subtract(this.position()).normalize().scale(velocity);
                    this.setDeltaMovement(motion.lerp(returnMotion, (double)0.1f));
                    if (this.isAlive() && this.distanceTo((Entity)scytheOwner) < 3.0f) {
                        if (scytheOwner instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)scytheOwner;
                            ReboundHandler.pickupScythe(this, scythe, player);
                        }
                        SoundHelper.playSound((Entity)scytheOwner, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_CATCH.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)this.level().getRandom(), (float)0.75f, (float)1.25f));
                        this.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
        } else {
            if (this.isMaelstrom() && !this.isNarrow()) {
                WeaponParticleEffects.spawnMaelstromParticles(this);
            }
            this.addTrailPoints();
            this.theFormer.tickTrailPoints();
            this.theLatter.tickTrailPoints();
            this.updateRotation();
        }
    }

    public void playSound() {
        if (this.age % 3 == 0) {
            float pitch = (float)((double)0.8f + Math.sin((float)this.level().getGameTime() * 0.5f) * (double)0.2f);
            float volumeScalar = Mth.clamp((float)((float)this.age / 12.0f), (float)0.0f, (float)1.0f);
            if (this.isInWater()) {
                volumeScalar *= 0.2f;
                pitch *= 0.5f;
            }
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_SPINS.get()), (float)(0.6f * volumeScalar), (float)pitch);
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_SWEEP.get()), (float)(0.4f * volumeScalar), (float)pitch);
        }
    }

    public void addTrailPoints() {
        if (this.isNarrow()) {
            Vec3 direction = this.getDeltaMovement().normalize();
            float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(direction);
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                for (int j = 0; j < 2; ++j) {
                    TrailPointBuilder trail = j == 0 ? this.theFormer : this.theLatter;
                    float angle = this.spinOffset + 3.14f * (float)j + scalar;
                    Vec3 offset = direction.scale(Math.sin(angle)).add(up.scale(Math.cos(angle))).normalize().scale((double)1.2f);
                    trail.addTrailPoint(position.add(offset));
                }
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            float progress = (float)(i + 1) * 0.5f;
            Vec3 position = this.getPosition(progress);
            float scalar = ((float)this.age + progress) / 2.0f;
            for (int j = 0; j < 2; ++j) {
                TrailPointBuilder trail = j == 0 ? this.theFormer : this.theLatter;
                double xOffset = Math.cos(this.spinOffset + 3.14f * (float)j + scalar) * (double)1.2f;
                double zOffset = Math.sin(this.spinOffset + 3.14f * (float)j + scalar) * (double)1.2f;
                trail.addTrailPoint(position.add(xOffset, 0.0, zOffset));
            }
        }
    }

    public void flyBack(Entity scytheOwner) {
        Vec3 ownerPos = scytheOwner.position().add(0.0, (double)(scytheOwner.getBbHeight() * 0.5f), 0.0);
        Vec3 returnMotion = ownerPos.subtract(this.position()).normalize().scale(0.75);
        this.setDeltaMovement(returnMotion);
    }
}

