/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.scythe;

import com.sammy.malum.common.entity.scythe.AbstractScytheProjectileEntity;
import com.sammy.malum.common.item.curiosities.curios.sets.scythe.CurioHowlingMaelstromRing;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.SoundHelper;

public class LocalizedMaelstromEntity
extends AbstractScytheProjectileEntity {
    public LocalizedMaelstromEntity(Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)MalumEntities.SCYTHE_MAELSTROM.get()), level);
    }

    public LocalizedMaelstromEntity(Level level, double pX, double pY, double pZ) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)MalumEntities.SCYTHE_MAELSTROM.get()), pX, pY, pZ, level);
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            --this.returnTimer;
            if (this.returnTimer <= 0) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity scytheOwner = (LivingEntity)entity;
                CurioHowlingMaelstromRing.handleMaelstrom(serverLevel, scytheOwner, this);
                this.playSound();
            }
        } else {
            WeaponParticleEffects.spawnMaelstromParticles(this);
        }
    }

    public void playSound() {
        if (this.age % 2 == 0) {
            float pitch = (float)((double)0.8f + Math.sin((float)this.level().getGameTime() * 0.5f) * (double)0.2f);
            float volumeScalar = Mth.clamp((float)((float)this.age / 12.0f), (float)0.0f, (float)1.0f);
            if (this.isInWater()) {
                volumeScalar *= 0.2f;
                pitch *= 0.5f;
            }
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_SWEEP.get()), (float)(0.4f * volumeScalar), (float)pitch);
        }
    }
}

