/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.visual_effects.TotemParticleEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemPoleBlockEntity
extends LodestoneBlockEntity {
    protected final SpiritArcanaType spirit;
    protected TotemPoleState state = TotemPoleState.INACTIVE;
    protected BlockPos basePos;
    protected int glow;

    public TotemPoleBlockEntity(BlockEntityType<? extends TotemPoleBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.spirit = (SpiritArcanaType)SpiritTypeProperty.getSpiritType(state).value();
    }

    public TotemPoleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemPoleBlockEntity>)((BlockEntityType)MalumBlockEntities.TOTEM_POLE.get()), pos, state);
    }

    public Block getLogBlock() {
        return this.asBlock().getLogBlock();
    }

    public boolean isSoulwood() {
        return this.asBlock().isSoulwood();
    }

    public TotemPoleBlock<?> asBlock() {
        return (TotemPoleBlock)this.getBlockState().getBlock();
    }

    public SpiritArcanaType getSpirit() {
        return this.spirit;
    }

    public TotemPoleState getState() {
        return this.state;
    }

    public void setState(TotemPoleState state) {
        this.state = state;
        this.setDirty();
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack held, InteractionHand hand) {
        if (held.canPerformAction(ItemAbilities.AXE_STRIP)) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.strip(serverLevel);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (held.is(MalumTags.ItemTags.IS_TOTEMIC_TOOL)) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.state.equals((Object)TotemPoleState.CHARGING) || this.state.equals((Object)TotemPoleState.ACTIVE)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                this.toggleVisuals(serverLevel);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(player, held, hand);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("state", this.state.ordinal());
        tag.putInt("glow", this.glow);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.state = TotemPoleState.values()[tag.getInt("state")];
        this.glow = tag.getInt("glow");
        super.loadAdditional(tag, pRegistries);
    }

    public void commonTick(Level level) {
        if (this.state.equals((Object)TotemPoleState.INACTIVE)) {
            if (this.glow > 0) {
                --this.glow;
            }
        } else {
            int cap;
            int n = cap = this.state.equals((Object)TotemPoleState.CHARGING) ? 10 : 20;
            if (this.glow < cap) {
                ++this.glow;
            }
        }
    }

    public void clientTick(Level level) {
        if (this.spirit != null && this.state.equals((Object)TotemPoleState.ACTIVE)) {
            TotemParticleEffects.activeTotemPoleParticles(this);
        }
    }

    public float getGlowDelta() {
        return (float)this.glow / 20.0f;
    }

    public void brieflyActivate(ServerLevel level) {
        float pitch = Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, pitch);
        level.playSound(null, this.worldPosition, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, pitch);
        this.glow = 10;
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(level);
        this.setDirty();
    }

    public void beginCharging(ServerLevel level, TotemBaseBlockEntity totemBase, int index) {
        float pitch = 0.8f + 0.2f * (float)index;
        this.state = TotemPoleState.CHARGING;
        this.basePos = totemBase.getBlockPos();
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_CHARGE.get(), SoundSource.BLOCKS, 1.0f, pitch);
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(level);
        this.setDirty();
    }

    public void strip(ServerLevel level) {
        level.setBlockAndUpdate(this.worldPosition, this.getLogBlock().defaultBlockState());
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, 0.7f);
        level.playSound(null, this.worldPosition, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(level);
    }

    public void toggleVisuals(ServerLevel level) {
        if (this.state.equals((Object)TotemPoleState.VISUAL_ONLY)) {
            this.state = TotemPoleState.INACTIVE;
        } else if (this.state.equals((Object)TotemPoleState.INACTIVE)) {
            this.state = TotemPoleState.VISUAL_ONLY;
        }
        float pitch = this.state.equals((Object)TotemPoleState.INACTIVE) ? 1.2f : 0.7f;
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, pitch);
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(level);
        this.setDirty();
    }

    public static enum TotemPoleState {
        INACTIVE,
        VISUAL_ONLY,
        CHARGING,
        ACTIVE;

    }
}

