/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemBaseBlockEntity
extends LodestoneBlockEntity {
    private static final int INTERVAL = 20;
    public final boolean corrupted;
    protected TotemBaseState state = TotemBaseState.INACTIVE;
    protected SpiritRiteType rite;
    protected Direction totemDirection;
    protected int totemHeight;
    protected int timer;
    protected int timerPause;

    public TotemBaseBlockEntity(BlockEntityType<? extends TotemBaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.corrupted = ((TotemBaseBlock)state.getBlock()).corrupted;
    }

    public TotemBaseBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemBaseBlockEntity>)((BlockEntityType)MalumBlockEntities.TOTEM_BASE.get()), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putInt("state", this.state.ordinal());
        if (this.rite != null) {
            this.rite.save(compound);
        }
        if (this.totemDirection != null) {
            compound.putInt("direction", this.totemDirection.ordinal());
        }
        compound.putInt("totemHeight", this.totemHeight);
        compound.putInt("timer", this.timer);
        compound.putInt("timerPause", this.timerPause);
        super.saveAdditional(compound, registries);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        if (compound.contains("state")) {
            this.state = TotemBaseState.values()[compound.getInt("state")];
        }
        this.rite = SpiritRiteType.load(compound).orElse(null);
        if (compound.contains("direction")) {
            this.totemDirection = Direction.values()[compound.getInt("direction")];
        }
        this.totemHeight = compound.getInt("totemHeight");
        this.timer = compound.getInt("timer");
        this.timerPause = compound.getInt("timerPause");
        super.loadAdditional(compound, pRegistries);
    }

    public void serverTick(ServerLevel level) {
        switch (this.state.ordinal()) {
            case 2: {
                this.updateRite(level);
                break;
            }
            case 1: {
                --this.timer;
                if (this.timer > 0) break;
                BlockPos polePos = this.worldPosition.above(this.totemHeight + 1);
                BlockEntity blockEntity = level.getBlockEntity(polePos);
                if (blockEntity instanceof TotemPoleBlockEntity) {
                    TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
                    this.timer = 20;
                    this.addTotemPole(level, pole);
                    break;
                }
                SpiritRiteType rite = MalumSpiritRiteTypes.getRite(level, this);
                if (rite == null) {
                    this.setState(level, TotemBaseState.INACTIVE);
                    return;
                }
                this.rite = rite;
                this.setTotemPoleState(level, TotemPoleBlockEntity.TotemPoleState.ACTIVE);
                this.setState(level, TotemBaseState.ACTIVE);
            }
        }
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack pStack, InteractionHand pHand) {
        if (this.state.equals((Object)TotemBaseState.ASSEMBLING)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.getFirstTotemPole().isPresent()) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.state.equals((Object)TotemBaseState.ACTIVE)) {
                    this.setState(serverLevel, TotemBaseState.INACTIVE);
                } else {
                    this.setState(serverLevel, TotemBaseState.ASSEMBLING);
                }
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onBreak(@Nullable Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.setState(serverLevel, TotemBaseState.INACTIVE);
        }
    }

    public void receiveSparkUpdate() {
        this.timerPause = 10;
    }

    public TotemBaseState getState() {
        return this.state;
    }

    public SpiritRiteType getRite() {
        return this.rite;
    }

    public int getTotemHeight() {
        return this.totemHeight;
    }

    public Direction getTotemDirection() {
        if (this.totemDirection != null) {
            return this.totemDirection;
        }
        BlockState above = this.level.getBlockState(this.getBlockPos().above());
        if (above.getBlock() instanceof TotemPoleBlock) {
            this.totemDirection = (Direction)above.getValue((Property)TotemPoleBlock.HORIZONTAL_FACING);
            return this.totemDirection;
        }
        MalumMod.LOGGER.warn("Totem Base at {} has no totem pole above it, defaulting to north direction", (Object)this.worldPosition);
        return Direction.NORTH;
    }

    public void updateRite(ServerLevel level) {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timerPause > 0) {
            --this.timerPause;
            return;
        }
        if (this.canTriggerRite()) {
            this.triggerRite(level);
            this.notifyObservers();
        }
    }

    public boolean canTriggerRite() {
        return this.timer == 0;
    }

    public void triggerRite(ServerLevel level) {
        if (this.rite == null) {
            return;
        }
        this.timer = this.rite.getEffect().getCooldown();
        this.rite.triggerRiteEffect(level, this);
    }

    public void addTotemPole(ServerLevel level, TotemPoleBlockEntity pole) {
        ++this.totemHeight;
        pole.beginCharging(level, this, this.totemHeight);
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }

    public void setState(ServerLevel level, TotemBaseState newState) {
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (newState.equals((Object)TotemBaseState.INACTIVE)) {
            this.playSound((SoundEvent)MalumSoundEvents.TOTEM_CANCELLED.get());
            this.setTotemPoleState(level, TotemPoleBlockEntity.TotemPoleState.INACTIVE);
            this.totemHeight = 0;
            this.rite = null;
        }
        if (newState.equals((Object)TotemBaseState.ACTIVE)) {
            this.playSound((SoundEvent)MalumSoundEvents.TOTEM_ACTIVATED.get());
        }
        this.state = newState;
        this.timer = 0;
        BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)this.worldPosition);
    }

    public void setTotemPoleState(ServerLevel level, TotemPoleBlockEntity.TotemPoleState state) {
        for (TotemPoleBlockEntity totemPole : this.getTotemPoles(level)) {
            totemPole.setState(state);
        }
    }

    public List<SpiritArcanaType> getSpirits(ServerLevel level) {
        return this.getTotemPoles(level).stream().map(TotemPoleBlockEntity::getSpirit).toList();
    }

    public List<TotemPoleBlockEntity> getTotemPoles(ServerLevel level) {
        ArrayList<TotemPoleBlockEntity> totemPoles = new ArrayList<TotemPoleBlockEntity>();
        BlockPos.MutableBlockPos mutable = this.getBlockPos().mutable();
        for (int i = 0; i < this.totemHeight; ++i) {
            mutable.move(Direction.UP);
            BlockEntity blockEntity = level.getBlockEntity((BlockPos)mutable);
            if (!(blockEntity instanceof TotemPoleBlockEntity)) continue;
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)blockEntity;
            totemPoles.add(totemPole);
        }
        return totemPoles;
    }

    public boolean isActiveOrAssembling() {
        return !this.state.equals((Object)TotemBaseState.INACTIVE);
    }

    public Optional<TotemPoleBlockEntity> getFirstTotemPole() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.above());
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)blockEntity;
            return Optional.of(totemPole);
        }
        return Optional.empty();
    }

    public static enum TotemBaseState {
        INACTIVE,
        ASSEMBLING,
        ACTIVE;

    }
}

