/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.mana_mote;

import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlockEntity;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class ManaMoteBlock
extends LodestoneEntityBlock<ManaMoteBlockEntity> {
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final SpiritTypeProperty SPIRIT_TYPE = SpiritTypeProperty.SPIRIT_TYPE;

    public ManaMoteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SPIRIT_TYPE, (Comparable)((Object)"sacred")));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
        builder.add(new Property[]{SPIRIT_TYPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        for (Direction direction : Direction.values()) {
            BooleanProperty property = this.getDirectionProperty(direction);
            BlockPos pos = context.getClickedPos();
            BlockPos relative = pos.relative(direction);
            boolean value = context.getLevel().getBlockState(relative).getBlock() instanceof ManaMoteBlock;
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(value));
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        Direction direction = Direction.fromDelta((int)(fromPos.getX() - pos.getX()), (int)(fromPos.getY() - pos.getY()), (int)(fromPos.getZ() - pos.getZ()));
        if (direction != null) {
            BooleanProperty property = this.getDirectionProperty(direction);
            boolean value = level.getBlockState(fromPos).getBlock() instanceof ManaMoteBlock;
            level.setBlock(pos, (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(value)), 2);
        }
    }

    public static BlockState createManaMoteState(BlockState state, SpiritLike spiritType) {
        return SpiritTypeProperty.setSpiritType(state, spiritType);
    }

    public BooleanProperty getDirectionProperty(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public static boolean isOccluded(BlockState state, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> (Boolean)state.getValue((Property)UP);
            case Direction.DOWN -> (Boolean)state.getValue((Property)DOWN);
            case Direction.NORTH -> (Boolean)state.getValue((Property)NORTH);
            case Direction.SOUTH -> (Boolean)state.getValue((Property)SOUTH);
            case Direction.EAST -> (Boolean)state.getValue((Property)EAST);
            case Direction.WEST -> (Boolean)state.getValue((Property)WEST);
        };
    }
}

