/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens.progression;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.PlacedEntryAcceptor;
import com.sammy.malum.client.screen.codex.handlers.EntryObjectHandler;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.core.systems.events.SetupMalumCodexEntriesEvent;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public abstract class AbstractProgressionCodexScreen
extends AbstractMalumCodexScreen
implements PlacedEntryAcceptor {
    public static final ResourceLocation FRAME_TEXTURE = MalumMod.malumPath("textures/gui/book/frame.png");
    public static final ResourceLocation FRAME_FADE_TEXTURE = MalumMod.malumPath("textures/gui/book/frame_fade.png");
    public static final int BOOK_WIDTH = 378;
    public static final int BOOK_HEIGHT = 250;
    public static final int BOOK_INSIDE_WIDTH = 344;
    public static final int BOOK_INSIDE_HEIGHT = 218;
    protected float oldBackgroundXOffset;
    protected float oldBackgroundYOffset;
    protected float backgroundXOffset;
    protected float backgroundYOffset;
    protected float oldObjectXOffset;
    protected float oldObjectYOffset;
    protected float objectXOffset;
    protected float objectYOffset;
    protected float xOffset;
    protected float yOffset;
    protected float cachedXOffset;
    protected float cachedYOffset;
    protected boolean ignoreNextMouseInput;
    protected int voidFadeoutTimer;
    protected int voidFadeoutCounter;
    public final EntryObjectHandler progressionObjects = new EntryObjectHandler();
    public final List<PlacedBookEntry> entries = new ArrayList<PlacedBookEntry>();
    protected final int backgroundImageWidth;
    protected final int backgroundImageHeight;
    protected final Minecraft minecraft = Minecraft.getInstance();

    protected AbstractProgressionCodexScreen(Holder<SoundEvent> sweetenerSound, int backgroundImageWidth, int backgroundImageHeight) {
        super((Component)Component.empty(), sweetenerSound);
        this.backgroundImageWidth = backgroundImageWidth;
        this.backgroundImageHeight = backgroundImageHeight;
        this.setupEntries();
        NeoForge.EVENT_BUS.post((Event)new SetupMalumCodexEntriesEvent(this));
        this.setupObjects();
        this.faceOrigin();
    }

    public void init() {
        super.init();
    }

    public abstract void renderBackground(PoseStack var1);

    public abstract void setupEntries();

    public abstract Color getOutlineColor();

    public List<PlacedBookEntry> getEntries() {
        return this.entries;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackground(poseStack);
        GL11.glEnable((int)3089);
        this.constrictEntryRendering();
        float delta = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        float x = Mth.lerp((float)delta, (float)this.oldObjectXOffset, (float)this.objectXOffset);
        float y = Mth.lerp((float)delta, (float)this.oldObjectYOffset, (float)this.objectYOffset);
        float objectX = (float)guiLeft + 172.0f + x;
        float objectY = (float)guiTop + 109.0f + y;
        this.progressionObjects.renderObjects(this, guiGraphics, objectX, objectY, mouseX, mouseY, partialTicks);
        GL11.glDisable((int)3089);
        if (this.voidFadeoutTimer > 0) {
            CodexRenderHelper.renderTransitionFade(this, poseStack);
        }
        this.renderFade(poseStack);
        CodexRenderHelper.renderTexture(FRAME_TEXTURE, poseStack, (float)guiLeft, (float)guiTop, 400, 0.0f, 0.0f, 378, 250);
        this.progressionObjects.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
        this.doLateRendering();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.ignoreNextMouseInput) {
            this.ignoreNextMouseInput = false;
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (this.xOffset != this.cachedXOffset || this.yOffset != this.cachedYOffset) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        this.progressionObjects.click(this, mouseX, mouseY);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset += (float)dragX;
        this.yOffset += (float)dragY;
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.cachedXOffset = this.xOffset;
        this.cachedYOffset = this.yOffset;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        super.onClose();
        this.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_CODEX_CLOSE, 0.75f);
    }

    public void tick() {
        this.progressionObjects.tick(this);
        if (this.voidFadeoutTimer > 0) {
            --this.voidFadeoutTimer;
        }
        this.oldBackgroundXOffset = this.backgroundXOffset;
        this.oldBackgroundYOffset = this.backgroundYOffset;
        this.backgroundXOffset += (this.xOffset - this.backgroundXOffset) * 0.6f;
        this.backgroundYOffset += (this.yOffset - this.backgroundYOffset) * 0.6f;
        this.oldObjectXOffset = this.objectXOffset;
        this.oldObjectYOffset = this.objectYOffset;
        this.objectXOffset += (this.xOffset - this.objectXOffset) * 0.75f;
        this.objectYOffset += (this.yOffset - this.objectYOffset) * 0.75f;
        super.tick();
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        if (!this.isInView(mouseX, mouseY)) {
            return false;
        }
        return super.isHovering(mouseX, mouseY, posX, posY, width, height);
    }

    public void correctOOBB() {
        if (this.progressionObjects.hasVisibleObject(this)) {
            return;
        }
        Vec2 offsets = this.clampOffsets(this.xOffset, this.yOffset, 1.0f, 0.1f, 0.8f);
        if (offsets.x != this.xOffset || offsets.y != this.yOffset) {
            this.faceOrigin();
        }
    }

    public void setupObjects() {
        Window window = this.minecraft.getWindow();
        this.width = window.getGuiScaledWidth();
        this.height = window.getGuiScaledHeight();
        this.progressionObjects.setupEntryObjects(this);
    }

    public void faceOrigin() {
        this.faceObject(this.progressionObjects.getOriginObject());
    }

    public void faceObject(BookObject<?> object) {
        Window window = this.minecraft.getWindow();
        this.width = window.getGuiScaledWidth();
        this.height = window.getGuiScaledHeight();
        this.xOffset = -object.posX;
        this.yOffset = -object.posY;
        this.backgroundXOffset = this.xOffset;
        this.backgroundYOffset = this.yOffset;
    }

    public void renderBackground(PoseStack poseStack, ResourceLocation texture, float xModifier, float yModifier) {
        float delta = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        float x = Mth.lerp((float)delta, (float)this.oldBackgroundXOffset, (float)this.backgroundXOffset);
        float y = Mth.lerp((float)delta, (float)this.oldBackgroundYOffset, (float)this.backgroundYOffset);
        Vec2 offsets = this.clampOffsets(x, y, 0.8f, 0.0f, 1.0f);
        float xOffset = offsets.x;
        float yOffset = offsets.y;
        int insideLeft = this.getInsideLeft();
        int insideTop = this.getInsideTop();
        float uOffset = (float)this.backgroundImageWidth / 12.0f - xOffset * xModifier;
        float vOffset = (float)(this.backgroundImageHeight - 218) - yOffset * yModifier;
        VFXBuilders.createScreen().setTexture(texture).setShader(GameRenderer::getPositionTexColorShader).setPositionWithWidth((float)insideLeft, (float)insideTop, 344.0f, 218.0f).setUVWithWidth(uOffset, vOffset, 344.0f, 218.0f, (float)this.backgroundImageWidth / 2.0f, (float)this.backgroundImageHeight / 2.0f).setZLevel(-100).multiplyColor(0.75f).blit(poseStack);
    }

    public void renderFade(PoseStack poseStack) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(32.0f);
        shaderInstance.safeGetUniform("XFrequency").set(16.0f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        shaderInstance.safeGetUniform("Intensity").set(120.0f);
        int insideLeft = this.getInsideLeft();
        int insideTop = this.getInsideTop();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        VFXBuilders.createScreen().setTexture(FRAME_FADE_TEXTURE).setShader((ShaderInstance)shaderInstance).setPositionWithWidth((float)insideLeft, (float)insideTop, 344.0f, 218.0f).setZLevel(400).blit(poseStack);
        shaderInstance.setUniformDefaults();
        RenderSystem.disableBlend();
    }

    public Vec2 clampOffsets(float x, float y, float horizontalClamp, float bottomClamp, float topClamp) {
        float xOffset = x;
        float xMin = (float)(-this.backgroundImageWidth) * horizontalClamp;
        float xMax = (float)this.backgroundImageWidth * horizontalClamp;
        if (xOffset < xMin || xOffset > xMax) {
            xOffset = Mth.clamp((float)xOffset, (float)xMin, (float)xMax);
        }
        float yOffset = y;
        float yMin = (float)(-this.backgroundImageHeight) * bottomClamp;
        float yMax = (float)this.backgroundImageHeight * topClamp;
        if (yOffset < yMin || yOffset > yMax) {
            yOffset = Mth.clamp((float)yOffset, (float)yMin, (float)yMax);
        }
        return new Vec2(xOffset, yOffset);
    }

    public boolean isInView(double x, double y) {
        return x >= (double)this.getInsideLeft() && y >= (double)this.getInsideTop() && x <= (double)(this.getInsideLeft() + 344) && y <= (double)(this.getInsideTop() + 218);
    }

    public void constrictEntryRendering() {
        int scale = (int)this.getMinecraft().getWindow().getGuiScale();
        GL11.glScissor((int)(this.getInsideLeft() * scale), (int)(this.getMinecraft().getWindow().getHeight() - (this.getInsideTop() + 218) * scale), (int)(344 * scale), (int)(218 * scale));
    }

    public int getInsideLeft() {
        return this.getGuiLeft() + 17;
    }

    public int getInsideTop() {
        return this.getGuiTop() + 14;
    }

    public int getGuiLeft() {
        return (this.width - 378) / 2;
    }

    public int getGuiTop() {
        return (this.height - 250) / 2;
    }

    public float getVoidFadeoutDelta() {
        return (float)this.voidFadeoutTimer / (float)this.getVoidFadeoutDuration();
    }

    public int getVoidFadeoutDuration() {
        return 80 - Mth.clamp((int)(this.voidFadeoutCounter - 2), (int)0, (int)4) * 10;
    }
}

