/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class AbstractMalumCodexScreen
extends Screen {
    protected final Holder<SoundEvent> sweetenerSound;
    protected List<Runnable> lateRendering = new ArrayList<Runnable>();
    protected List<Runnable> lateRenderingCapture = new ArrayList<Runnable>();
    protected boolean isCapturingLateRendering = false;
    protected boolean isVoidTouched;

    protected AbstractMalumCodexScreen(Component pTitle, Holder<SoundEvent> sweetenerSound) {
        super(pTitle);
        this.minecraft = Minecraft.getInstance();
        this.sweetenerSound = sweetenerSound;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return mouseX > (double)posX && mouseX < (double)(posX + (float)width) && mouseY > (double)posY && mouseY < (double)(posY + (float)height);
    }

    public void playPageFlipSound(Holder<SoundEvent> soundEvent, float pitch) {
        this.playSound(soundEvent, 1.0f, Math.max(1.0f, pitch * 0.8f));
        this.playSound(this.sweetenerSound, 0.35f, pitch);
    }

    public void playSweetenedSound(Holder<SoundEvent> soundEvent, float sweetenerPitch) {
        this.playSweetenedSound(soundEvent, 1.0f, sweetenerPitch);
    }

    public void playSweetenedSound(Holder<SoundEvent> soundEvent, float sweetenerVolume, float sweetenerPitch) {
        this.playSound(soundEvent, 1.0f, 1.0f);
        this.playSound(this.sweetenerSound, sweetenerVolume, sweetenerPitch);
    }

    public void playSound(Holder<SoundEvent> soundEvent, float volume, float pitch) {
        this.minecraft.player.playNotifySound((SoundEvent)soundEvent.value(), SoundSource.PLAYERS, volume, pitch);
    }

    public boolean captureLateRendering() {
        this.lateRenderingCapture = new ArrayList<Runnable>();
        this.isCapturingLateRendering = true;
        return false;
    }

    public void renderLater(Runnable runnable) {
        if (this.isCapturingLateRendering) {
            this.lateRenderingCapture.add(runnable);
            return;
        }
        this.lateRendering.add(runnable);
    }

    public void doLateRendering() {
        if (this.isCapturingLateRendering) {
            this.lateRendering.addAll(this.lateRenderingCapture);
            this.lateRenderingCapture.clear();
            this.isCapturingLateRendering = false;
        }
        this.lateRendering.forEach(Runnable::run);
        this.lateRendering.clear();
    }

    public void setVoidTouched(boolean isVoidTouched) {
        this.isVoidTouched = isVoidTouched;
    }

    public boolean isVoidTouched() {
        return this.isVoidTouched;
    }
}

