/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects.progression;

import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.pages.text.SpiritRiteTextPage;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;

public class RiteEntryObject
extends ProgressionEntryObject {
    public final SpiritRiteType riteType;

    public RiteEntryObject(BookEntry entry, int posX, int posY) {
        super(entry, posX, posY);
        Optional<SpiritRiteType> riteType = RiteEntryObject.getRiteTypeFromEntry(entry);
        if (!riteType.isPresent()) {
            throw new IllegalArgumentException("Entry " + entry.translationKey() + " lacks a spirit rite page");
        }
        this.riteType = riteType.get();
    }

    @Override
    public void render(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(screen, guiGraphics, mouseX, mouseY, partialTicks);
        CodexRenderHelper.renderRiteIcon(this.riteType, guiGraphics.pose(), this.getOffsetXPosition() + 8, this.getOffsetYPosition() + 8);
    }

    public static Optional<SpiritRiteType> getRiteTypeFromEntry(BookEntry entry) {
        return entry.pages.stream().filter(p -> p instanceof SpiritRiteTextPage).map(p -> ((SpiritRiteTextPage)p).rite).findAny();
    }
}

