/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.entries;

import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.BookEntryBuilder;
import com.sammy.malum.client.screen.codex.PlacedEntryAcceptor;
import com.sammy.malum.client.screen.codex.WidgetDesignType;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.RiteEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.SubspaceEntryObject;
import com.sammy.malum.client.screen.codex.pages.CyclingPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.pages.recipe.RuneworkingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritRiteRecipePage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritTransmutationRecipeTreePage;
import com.sammy.malum.client.screen.codex.pages.recipe.UnchainedTransmutationRecipePage;
import com.sammy.malum.client.screen.codex.pages.recipe.vanilla.CraftingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.vanilla.SmeltingPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextIconPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextItemPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.text.SpiritRiteTextPage;
import com.sammy.malum.client.screen.codex.pages.text.TextPage;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ArcanaProgressionScreen;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.registry.rite.RiteHolder;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteTypes;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TotemMagicEntries {
    public static void setupEntries(ArcanaProgressionScreen screen) {
        Item EMPTY = ItemStack.EMPTY.getItem();
        BookEntryBuilder strangeCrystalReexamination = BookEntry.create("strange_crystal.reexamination").addPage(new HeadlineTextPage("strange_crystal.reexamination", "strange_crystal.reexamination.1")).afterVoidReader();
        BookEntryBuilder strangeCrystalRevelation = BookEntry.create("strange_crystal.revelation").addPage(new HeadlineTextPage("strange_crystal.revelation", "strange_crystal.revelation.1")).afterUmbralCrystal();
        screen.addEntry("totem_magic", 0, 12, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.RUNEWOOD_TOTEM_BASE)).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("totem_magic", (Item)MalumItems.RUNEWOOD_TOTEM_BASE.get())).addPage(new TextPage("totem_magic.2")).addPage(new TextPage("totem_magic.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RUNEWOOD_TOTEM_BASE.get())).addReference(new EntryReference((Item)MalumItems.WAVEFORM_RUNEWOOD_TOTEM_BASE.get(), BookEntry.create("totem_magic.waveform_totemancy").addPage(new HeadlineTextItemPage("totem_magic.waveform_totemancy", (Item)MalumItems.WAVEFORM_RUNEWOOD_TOTEM_BASE.get())).addPage(new TextPage("totem_magic.waveform_totemancy.2")).addPage(new TextPage("totem_magic.waveform_totemancy.3")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.WAVEFORM_RUNEWOOD_TOTEM_BASE.get())))));
        screen.addEntry("managing_totems", 0, 13, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.TOTEMIC_STAFF)).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("managing_totems", "managing_totems.1", (Item)MalumItems.TOTEMIC_STAFF.get())).addPage(new TextPage("managing_totems.2")).addPage(new TextPage("managing_totems.3")).addPage(new CraftingPage((Item)MalumItems.TOTEMIC_STAFF.get(), EMPTY, EMPTY, (Item)MalumItems.RUNEWOOD_PLANKS.get(), EMPTY, Items.STICK, EMPTY, Items.STICK, EMPTY, EMPTY)));
        screen.addEntry("undirected_rite", 0, 14, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage(new HeadlineTextPage("undirected_rite")).addPage(new TextPage("undirected_rite.2")).addPage(new SpiritRiteTextPage(MalumSpiritRiteTypes.UNDIRECTED_RITE)).addPage(new SpiritRiteRecipePage(MalumSpiritRiteTypes.UNDIRECTED_RITE)));
        screen.addEntry("unchained_rite", 0, 15, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage(new HeadlineTextPage("unchained_rite")).addPage(new TextPage("unchained_rite.2")).addPage(new SpiritRiteTextPage(MalumSpiritRiteTypes.UNCHAINED_RITE)).addPage(new SpiritRiteRecipePage(MalumSpiritRiteTypes.UNCHAINED_RITE)).addPage(UnchainedTransmutationRecipePage.fromOutput("unchained_rite.soulwood", (Item)MalumItems.SOULWOOD_SAPLING.get())).addPage(new TextPage("unchained_rite.soulwood.1")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.SOULWOOD_TOTEM_BASE.get())).addPage(new TextPage("unchained_rite.soulwood.2")));
        screen.addEntry("blight", 1, 16, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.BLIGHTED_EARTH)).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("blight.intro", "blight.intro.1", (Item)MalumItems.BLIGHTED_EARTH.get())).addPage(new HeadlineTextPage("blight.composition", "blight.composition.1")).addPage(new HeadlineTextPage("blight.flora", "blight.flora.1")).addPage(new HeadlineTextPage("blight.spread", "blight.spread.1")).addPage(new HeadlineTextPage("blight.arcane_rite", "blight.arcane_rite.1")));
        screen.addEntry("scarstone", -1, 16, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.SCARSTONE)).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("scarstone", "scarstone.1", (Item)MalumItems.SCARSTONE.get())).addPage(new HeadlineTextPage("scarstone.material", "scarstone.material.1")).addPage(new HeadlineTextPage("scarstone.creation", "scarstone.creation.1")).addPage(new HeadlineTextPage("scarstone.strange_crystal", "scarstone.strange_crystal.1")).addPage(new HeadlineTextItemPage("strange_crystal.material", "strange_crystal.material.1", (Item)MalumItems.LARGE_STRANGE_CRYSTAL.get())).addPage(new HeadlineTextPage("strange_crystal.purpose", "strange_crystal.purpose.1")).addPage(new TextPage("strange_crystal.purpose.2")).addReference(new EntryReference((Item)MalumItems.MNEMONIC_FRAGMENT.get(), strangeCrystalReexamination)).addReference(new EntryReference((Item)MalumItems.UMBRAL_SPIRIT.get(), strangeCrystalRevelation)));
        screen.addEntry("soulwood", 0, 17, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.SOULWOOD_SAPLING)).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("soulwood", "soulwood.1", (Item)MalumItems.SOULWOOD_SAPLING.get())).addPage(new TextPage("soulwood.2")).addPage(new SmeltingPage((Item)MalumItems.SOULWOOD_LOG.get(), (Item)MalumItems.ARCANE_CHARCOAL.get())).addPage(CraftingPage.fullPage((Item)MalumItems.BLOCK_OF_ARCANE_CHARCOAL.get(), (Item)MalumItems.ARCANE_CHARCOAL.get())).addPage(new HeadlineTextPage("soulwood.blight")).addPage(new HeadlineTextPage("soulwood.bonemeal")).addPage(new HeadlineTextPage("soulwood.cursed_sap")).addPage(new CraftingPage(new ItemStack((ItemLike)MalumItems.CURSED_SAPBALL.get()), (Item)MalumItems.CURSED_SAP.get())));
        screen.addEntry("unchained_transmutation", 0, 18, b -> b.configureWidget(w -> w.setIcon(Items.SOUL_SAND).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextPage("unchained_transmutation", "unchained_transmutation.intro.1")).addPage(new TextPage("unchained_transmutation.intro.2")).addPage(new TextPage("unchained_transmutation.dirt.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.dirt", Items.DIRT)).addPage(new TextPage("unchained_transmutation.stone.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.stone", Items.STONE)).addPage(new TextPage("unchained_transmutation.basalt.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.basalt", Items.BASALT)).addPage(new TextPage("unchained_transmutation.mud.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.mud", Items.MUD)).addPage(new TextPage("unchained_transmutation.packed_mud.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.packed_mud", Items.PACKED_MUD)).addPage(new TextPage("unchained_transmutation.snow.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.snow", Items.SNOW_BLOCK)).addPage(new TextPage("unchained_transmutation.deepslate.1")).addPage(new SpiritTransmutationRecipeTreePage("unchained_transmutation.deepslate", Items.DEEPSLATE)));
        screen.addEntry("aura_empowerment", -3, 17, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.ARCANA_PYLON)).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("aura_empowerment", "aura_empowerment.1", (Item)MalumItems.ARCANA_PYLON.get())).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.ARCANA_PYLON.get())).addPage(new TextPage("aura_empowerment.2")).addPage(new CyclingPage(new HeadlineTextItemPage("aura_empowerment.elemental", (Item)MalumItems.AERIAL_SPIRIT.get()), new HeadlineTextItemPage("aura_empowerment.elemental", (Item)MalumItems.AQUEOUS_SPIRIT.get()), new HeadlineTextItemPage("aura_empowerment.elemental", (Item)MalumItems.EARTHEN_SPIRIT.get()), new HeadlineTextItemPage("aura_empowerment.elemental", (Item)MalumItems.INFERNAL_SPIRIT.get()))).addReference(new EntryReference((Item)MalumItems.ARCANA_PYLON.get(), BookEntry.create("aura_empowerment.other_pylon_applications").addPage(new HeadlineTextItemPage("aura_empowerment.other_pylon_applications.arcane", (Item)MalumItems.ARCANE_SPIRIT.get())))));
        screen.addEntry("locus_management", 3, 17, b -> b.configureWidget(w -> ((ProgressionEntryObject)w.setIcon((Supplier)MalumItems.RITE_ANCHOR)).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage(new HeadlineTextItemPage("locus_management", "locus_management.1", (Item)MalumItems.RITE_ANCHOR.get())).addPage(new TextPage("locus_management.2")).addPage(new TextPage("locus_management.3")).addPage(new TextPage("locus_management.4")).addPage(new TextPage("locus_management.5")).addPage(SpiritInfusionPage.fromOutput((Item)MalumItems.RITE_ANCHOR.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.sacred", (SpiritLike)MalumItems.SACRED_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.wicked", (SpiritLike)MalumItems.WICKED_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.arcane", (SpiritLike)MalumItems.ARCANE_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.eldritch", (SpiritLike)MalumItems.ELDRITCH_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.aerial", (SpiritLike)MalumItems.AERIAL_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.aqueous", (SpiritLike)MalumItems.AQUEOUS_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.earthen", (SpiritLike)MalumItems.EARTHEN_SPIRIT.get())).addPage(HeadlineTextIconPage.riteAnchorPage("locus_management.infernal", (SpiritLike)MalumItems.INFERNAL_SPIRIT.get())).addPage(new HeadlineTextPage("locus_management.elemental_boons")).addPage(new TextPage("locus_management.elemental_boons.2")).addPage(new HeadlineTextPage("locus_management.wicked_order")).addPage(new TextPage("locus_management.wicked_order.2")));
        TotemMagicEntries.addBundledRiteEntry(screen, "sacred_rites", 1, 13, MalumSpiritRiteTypes.RITE_OF_HEALING, MalumSpiritRiteTypes.RITE_OF_NOURISHMENT, MalumSpiritRiteTypes.RITE_OF_NURTURING, MalumSpiritRiteTypes.RITE_OF_LUST);
        TotemMagicEntries.addBundledRiteEntry(screen, "wicked_rites", -1, 13, MalumSpiritRiteTypes.RITE_OF_HARMING, MalumSpiritRiteTypes.RITE_OF_EMPOWERMENT, MalumSpiritRiteTypes.RITE_OF_CULLING, MalumSpiritRiteTypes.RITE_OF_RAISING);
        TotemMagicEntries.addBundledRiteEntry(screen, "aerial_rites", 3, 14, MalumSpiritRiteTypes.RITE_OF_THE_HOWLING_GALE, MalumSpiritRiteTypes.RITE_OF_THE_SKY_TETHER, MalumSpiritRiteTypes.RITE_OF_GRAVITY, MalumSpiritRiteTypes.RITE_OF_ASCENSION, MalumItems.RUNE_OF_HOWLING_GALE, MalumItems.RUNE_OF_SKY_TETHER);
        TotemMagicEntries.addBundledRiteEntry(screen, "aqueous_rites", 2, 14, MalumSpiritRiteTypes.RITE_OF_THE_FLOWING_GRASP, MalumSpiritRiteTypes.RITE_OF_THE_GOOD_TIDES, MalumSpiritRiteTypes.RITE_OF_SOAKING, MalumSpiritRiteTypes.RITE_OF_SAPPING, MalumItems.RUNE_OF_FLOWING_GRASP, MalumItems.RUNE_OF_GOOD_TIDES);
        TotemMagicEntries.addBundledRiteEntry(screen, "earthen_rites", -3, 14, MalumSpiritRiteTypes.RITE_OF_THE_STONE_WARD, MalumSpiritRiteTypes.RITE_OF_THE_OAKEN_MIGHT, MalumSpiritRiteTypes.RITE_OF_CREATION, MalumSpiritRiteTypes.RITE_OF_DESTRUCTION, MalumItems.RUNE_OF_STONE_WARD, MalumItems.RUNE_OF_OAKEN_MIGHT);
        TotemMagicEntries.addBundledRiteEntry(screen, "infernal_rites", -2, 14, MalumSpiritRiteTypes.RITE_OF_THE_BURNING_FERVOR, MalumSpiritRiteTypes.RITE_OF_THE_FIERY_EMBRACE, MalumSpiritRiteTypes.RITE_OF_SMELTING, MalumSpiritRiteTypes.RITE_OF_QUICKENING, MalumItems.RUNE_OF_BURNING_FERVOR, MalumItems.RUNE_OF_FIERY_EMBRACE);
    }

    public static void addBundledRiteEntry(AbstractProgressionCodexScreen screen, String name, int x, int y, RiteHolder<SpiritRiteType> minorRunewood, RiteHolder<SpiritRiteType> minorSoulwood, RiteHolder<SpiritRiteType> majorRunewood, RiteHolder<SpiritRiteType> majorSoulwood) {
        SpiritHolder<SpiritArcanaType> definingSpirit = ((SpiritRiteType)minorRunewood.value()).getIdentifyingSpirit();
        SubspaceEntryObject.SubspaceWidgetSupplier acceptor = new SubspaceEntryObject.SubspaceWidgetSupplier();
        int horizontalOffset = x > 0 ? 1 : -1;
        TotemMagicEntries.addRiteEntry(acceptor, minorRunewood, x, y - 1);
        TotemMagicEntries.addRiteEntry(acceptor, minorSoulwood, x + horizontalOffset, y);
        TotemMagicEntries.addRiteEntry(acceptor, majorRunewood, x - horizontalOffset, y);
        TotemMagicEntries.addRiteEntry(acceptor, majorSoulwood, x, y + 1);
        screen.addEntry(name, x, y, b -> b.setWidgetSupplier(acceptor).configureWidget(w -> w.setDesign(WidgetDesignType.SUBENTRY, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).setAssociatedSpirit(definingSpirit));
    }

    public static void addBundledRiteEntry(AbstractProgressionCodexScreen screen, String name, int x, int y, RiteHolder<SpiritRiteType> minorRunewood, RiteHolder<SpiritRiteType> minorSoulwood, RiteHolder<SpiritRiteType> majorRunewood, RiteHolder<SpiritRiteType> majorSoulwood, Supplier<Item> runewoodRune, Supplier<Item> soulwoodRune) {
        SpiritHolder<SpiritArcanaType> definingSpirit = ((SpiritRiteType)minorRunewood.value()).getIdentifyingSpirit();
        SubspaceEntryObject.SubspaceWidgetSupplier acceptor = new SubspaceEntryObject.SubspaceWidgetSupplier();
        int horizontalOffset = x > 0 ? 1 : -1;
        TotemMagicEntries.addRiteEntry(acceptor, minorRunewood, runewoodRune, x, y - 1);
        TotemMagicEntries.addRiteEntry(acceptor, minorSoulwood, soulwoodRune, x + horizontalOffset, y);
        TotemMagicEntries.addRiteEntry(acceptor, majorRunewood, x - horizontalOffset, y);
        TotemMagicEntries.addRiteEntry(acceptor, majorSoulwood, x, y + 1);
        screen.addEntry(name, x, y, b -> b.setWidgetSupplier(acceptor).configureWidget(w -> w.setDesign(WidgetDesignType.SUBENTRY, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).setAssociatedSpirit(definingSpirit));
    }

    public static void addRiteEntry(PlacedEntryAcceptor acceptor, RiteHolder<SpiritRiteType> riteType, int x, int y) {
        SpiritRiteType rite = (SpiritRiteType)riteType.value();
        acceptor.addEntry(rite.getName(), x, y, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, rite.isCorrupted() ? WidgetDesignType.FrameType.SOULWOOD : WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).setAssociatedSpirit(((SpiritRiteType)riteType.get()).getIdentifyingSpirit()).addPage(new SpiritRiteTextPage(riteType)).addPage(new SpiritRiteRecipePage(riteType)));
    }

    public static void addRiteEntry(PlacedEntryAcceptor acceptor, RiteHolder<SpiritRiteType> riteType, Supplier<Item> rune, int x, int y) {
        SpiritRiteType rite = (SpiritRiteType)riteType.value();
        acceptor.addEntry(rite.getName(), x, y, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, rite.isCorrupted() ? WidgetDesignType.FrameType.SOULWOOD : WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage(new SpiritRiteTextPage(riteType)).addPage(new SpiritRiteRecipePage(riteType)).addReference(TotemMagicEntries.totemicRuneEntry((Item)rune.get())));
    }

    public static EntryReference totemicRuneEntry(Item item) {
        String translationKey = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        return new EntryReference(item, BookEntry.create(translationKey).addPage(new HeadlineTextPage(translationKey)).addPage(RuneworkingPage.fromOutput(item)));
    }
}

