/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.data.component.SpiritJarContentsComponent;
import com.sammy.malum.common.item.spirit.SpiritJarItem;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SpiritJarItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final SpiritJarBlockEntity jar = new SpiritJarBlockEntity(BlockPos.ZERO, ((Block)MalumBlocks.SPIRIT_JAR.get()).defaultBlockState());
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public SpiritJarItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
        this.blockEntityRenderDispatcher = pBlockEntityRenderDispatcher;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (stack.getItem() instanceof SpiritJarItem) {
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            poseStack.popPose();
            poseStack.pushPose();
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(((Block)MalumBlocks.SPIRIT_JAR.get()).defaultBlockState());
            model = model.applyTransform(ctx, poseStack, SpiritJarItemRenderer.isLeftHand(ctx));
            poseStack.translate(-0.5, -0.5, -0.5);
            boolean glint = stack.hasFoil();
            for (BakedModel pass : model.getRenderPasses(stack, true)) {
                for (RenderType type : pass.getRenderTypes(stack, true)) {
                    VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)type, (boolean)true, (boolean)glint);
                    renderer.renderModelLists(pass, stack, light, overlay, poseStack, consumer);
                }
            }
            if (stack.has(MalumDataComponents.SPIRIT_JAR_CONTENTS)) {
                this.jar.contents = (SpiritJarContentsComponent)stack.get(MalumDataComponents.SPIRIT_JAR_CONTENTS);
                this.blockEntityRenderDispatcher.renderItem((BlockEntity)this.jar, poseStack, buffer, light, overlay);
            }
        }
    }

    public static boolean isLeftHand(ItemDisplayContext ctx) {
        return ctx == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || ctx == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }
}

