/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.thrown.ThrownConcentratedGluttony;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ThrownConcentratedGluttonyRenderer
extends EntityRenderer<ThrownConcentratedGluttony> {
    private static final Color GLUTTONY_GREEN = new Color(47, 81, 28);
    private static final Color GLUTTONY_DARK = new Color(31, 35, 30);
    private static final Color GLUTTONY_SHADE = new Color(14, 14, 16);
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean fullBright;

    public ThrownConcentratedGluttonyRenderer(EntityRendererProvider.Context pContext, float pScale, boolean pFullBright) {
        super(pContext);
        this.itemRenderer = pContext.getItemRenderer();
        this.scale = pScale;
        this.fullBright = pFullBright;
    }

    public ThrownConcentratedGluttonyRenderer(EntityRendererProvider.Context pContext) {
        this(pContext, 1.0f, false);
    }

    protected int getBlockLightLevel(ThrownConcentratedGluttony entity, BlockPos pPos) {
        return this.fullBright ? 15 : super.getBlockLightLevel((Entity)entity, pPos);
    }

    public void render(ThrownConcentratedGluttony entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entity) < 12.25)) {
            if (!entity.isFadingAway()) {
                poseStack.pushPose();
                poseStack.scale(this.scale, this.scale, this.scale);
                poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
                this.itemRenderer.renderStatic(entity.getItem(), ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, entity.level(), entity.getId());
                this.itemRenderer.renderStatic(entity.getItem(), ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)LodestoneRenderHandler.DEFERRED_RENDER.getTarget(), entity.level(), entity.getId());
                poseStack.popPose();
            }
            float scale = entity.getVisualEffectScalar();
            LodestoneRenderTypeBuilder additive = LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
            LodestoneRenderTypeBuilder transparent = LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT);
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(additive);
            for (TrailPointBuilder trail : entity.orbitingTrails) {
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_GREEN, GLUTTONY_DARK, scale * 0.5f, scale * 0.5f, partialTicks);
            }
            builder.setRenderType(transparent);
            for (TrailPointBuilder trail : entity.orbitingTrails) {
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_GREEN, GLUTTONY_SHADE, scale * 0.75f, scale * 2.0f, partialTicks);
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_DARK, GLUTTONY_SHADE, scale, scale * 3.0f, partialTicks);
            }
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        }
    }

    public ResourceLocation getTextureLocation(ThrownConcentratedGluttony entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

