/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.totemancy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.anchor.RiteAnchorBlock;
import com.sammy.malum.common.block.curiosities.totem.anchor.RiteAnchorBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class RiteAnchorRenderer
implements BlockEntityRenderer<RiteAnchorBlockEntity> {
    public RiteAnchorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RiteAnchorBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SpiritArcanaType spiritType = blockEntityIn.getSpirit();
        if (spiritType == null) {
            return;
        }
        float delta = blockEntityIn.getGlowDelta();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < 4; ++i) {
            int rotation = i * 90;
            Vector3f[] direction = Direction.fromYRot((double)rotation);
            if (RiteAnchorBlock.isOccluded(blockEntityIn.getBlockState(), (Direction)direction)) continue;
            poseStack.pushPose();
            poseStack.mulPose(Axis.YN.rotationDegrees((float)rotation));
            RiteAnchorRenderer.renderFace(poseStack, spiritType, MalumRenderTypeTokens.RITE_ANCHOR_GLOW_SIDE, RiteAnchorRenderer.getSideVertices(), delta, partialTicks);
            poseStack.popPose();
        }
        RiteAnchorRenderer.renderFace(poseStack, spiritType, MalumRenderTypeTokens.RITE_ANCHOR_GLOW_TOP, RiteAnchorRenderer.getTopVertices(), delta, partialTicks);
        RiteAnchorBlockEntity.AimState aimDirection = blockEntityIn.getAimDirection();
        if (aimDirection != null) {
            poseStack.pushPose();
            if (aimDirection.getData2d() != -1) {
                Vector3f[] vertices;
                for (Vector3f vertex : vertices = RiteAnchorRenderer.getTopVertices()) {
                    vertex.add(0.0f, 0.125f, 0.0f);
                }
                int rotation = aimDirection.getData2d();
                poseStack.mulPose(Axis.YN.rotationDegrees((float)(180 + rotation * 90)));
                RiteAnchorRenderer.renderFace(poseStack, spiritType, MalumRenderTypeTokens.RITE_ANCHOR_GLOW_POINTER, vertices, delta, partialTicks);
            } else {
                for (int i = 0; i < 4; ++i) {
                    Vector3f[] vertices;
                    for (Vector3f vertex : vertices = RiteAnchorRenderer.getSideVertices()) {
                        vertex.add(0.0f, 0.3125f, 0.0f);
                    }
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.YN.rotationDegrees((float)(i * 90)));
                    if (aimDirection == RiteAnchorBlockEntity.AimState.PULL) {
                        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
                        for (Vector3f vertex : vertices) {
                            vertex.add(0.0f, -0.625f, 0.0f);
                        }
                    }
                    RiteAnchorRenderer.renderFace(poseStack, spiritType, MalumRenderTypeTokens.RITE_ANCHOR_GLOW_POINTER_SMALL, vertices, delta, partialTicks);
                    poseStack.popPose();
                }
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static void renderFace(PoseStack poseStack, SpiritArcanaType spiritType, RenderTypeToken token, Vector3f[] vertices, float delta, float partialTicks) {
        ClientLevel level = Minecraft.getInstance().level;
        float gameTime = (float)level.getGameTime() + partialTicks;
        float alpha = delta * 0.7f;
        float ease = Easing.SINE_OUT.ease(delta, 0.0f, 1.0f, 1.0f);
        float offsetDistance = 0.2f - ease * 0.2f;
        float wobbleStrength = 0.1f - ease * 0.075f;
        int time = 160;
        float timer = gameTime % (float)time / (float)time;
        LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(token).withModifier(r -> r.setCullState(RenderStateShard.NO_CULL));
        for (int j = 0; j < 4; ++j) {
            Color color = j <= 1 ? spiritType.getPrimaryColor() : spiritType.getSecondaryColor();
            double offset = 0.0;
            if (offsetDistance > 0.0f) {
                double angle = (double)((float)j / 4.0f) * (Math.PI * 2);
                offset = (double)offsetDistance * Math.cos(angle += (double)timer * (Math.PI * 2));
                if (j % 2 == 0) {
                    offset *= -1.0;
                }
            }
            poseStack.pushPose();
            poseStack.translate(offset, 0.0, 0.0);
            CubeVertexData.applyVertexWobble((Vector3f[])vertices, (float)0.0f, (float)wobbleStrength);
            SpiritBasedWorldVFXBuilder.create(spiritType).setColor(color, alpha).setRenderType(renderType).renderQuad(poseStack, vertices, 1.0f);
            poseStack.popPose();
            alpha *= 1.0f - (delta + 0.2f) * 0.4f;
        }
    }

    @NotNull
    private static Vector3f[] getSideVertices() {
        return new Vector3f[]{new Vector3f(-0.55f, -0.5f, 0.55f), new Vector3f(0.55f, -0.5f, 0.55f), new Vector3f(0.55f, 0.5f, 0.55f), new Vector3f(-0.55f, 0.5f, 0.55f)};
    }

    @NotNull
    private static Vector3f[] getTopVertices() {
        return new Vector3f[]{new Vector3f(-0.55f, 0.55f, 0.55f), new Vector3f(0.55f, 0.55f, 0.55f), new Vector3f(0.55f, 0.55f, -0.55f), new Vector3f(-0.55f, 0.55f, -0.55f)};
    }
}

