/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.artifice;

import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.HashMap;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;

public class SpiritInfluenceRendererData
extends HashMap<SpiritArcanaType, Integer> {
    public static final WeakHashMap<IArtificeAcceptor, SpiritInfluenceRendererData> SPIRIT_INFLUENCE = new WeakHashMap();
    private long gameTimeCache;

    private SpiritInfluenceRendererData tickData(IArtificeAcceptor target) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level.getGameTime() == this.gameTimeCache) {
            return this;
        }
        this.gameTimeCache = level.getGameTime();
        SpiritArcanaType activeSpiritType = target.getActiveSpiritType();
        if (activeSpiritType != null) {
            this.merge(activeSpiritType, 1, (a, b) -> Math.min(a + b, this.maxValue()));
        }
        for (SpiritArcanaType spiritType : this.keySet()) {
            if (spiritType.equals(activeSpiritType)) continue;
            this.merge(spiritType, 1, (a, b) -> Math.max(a - b, 0));
        }
        return this;
    }

    public float getDelta(SpiritArcanaType spiritType) {
        return (float)this.getOrDefault(spiritType, 0).intValue() / (float)this.maxValue();
    }

    public int maxValue() {
        return 60;
    }

    public static SpiritInfluenceRendererData getSpiritInfluenceData(IArtificeAcceptor target) {
        if (!SPIRIT_INFLUENCE.containsKey(target)) {
            SPIRIT_INFLUENCE.put(target, new SpiritInfluenceRendererData());
        }
        return SPIRIT_INFLUENCE.get(target).tickData(target);
    }
}

