/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.artifice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.renderer.block.artifice.SpiritInfluenceRendererData;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.artifice.IArtificeModifierSource;
import com.sammy.malum.core.systems.item.HeldItemTracker;
import com.sammy.malum.registry.common.MalumTags;
import java.awt.Color;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public abstract class ArtificeAcceptorRenderer<T extends LodestoneBlockEntity>
implements BlockEntityRenderer<T> {
    public static final WeakHashMap<IArtificeAcceptor, Color> DEBUG_COLORS = new WeakHashMap();
    public static final HeldItemTracker FORK_TRACKER = new HeldItemTracker(p -> p.is(MalumTags.ItemTags.IS_ARTIFICE_TOOL));

    public static void renderModifiers(IArtificeAcceptor target, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        BlockEntity targetBlockEntity = (BlockEntity)target;
        BlockPos pos = targetBlockEntity.getBlockPos();
        poseStack.pushPose();
        poseStack.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        target.getAttributes().getInfluenceData((Level)level).ifPresent(p -> {
            for (ArtificeModifierSourceInstance modifier : p.modifiers()) {
                BlockPos modifierPosition = modifier.sourcePosition;
                BlockEntity modifierBlockEntity = level.getBlockEntity(modifierPosition);
                if (modifierBlockEntity == null) continue;
                BlockPos modifierBlockPos = modifierBlockEntity.getBlockPos();
                if (!(modifierBlockEntity instanceof IArtificeModifierSource)) continue;
                IArtificeModifierSource influencer = (IArtificeModifierSource)modifierBlockEntity;
                BlockEntityRenderer renderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(modifierBlockEntity);
                if (!(renderer instanceof ArtificeModifierSourceRenderer)) continue;
                ArtificeModifierSourceRenderer modifierRenderer = (ArtificeModifierSourceRenderer)renderer;
                poseStack.pushPose();
                poseStack.translate((float)modifierBlockPos.getX(), (float)modifierBlockPos.getY(), (float)modifierBlockPos.getZ());
                modifierRenderer.render(influencer, target, SpiritInfluenceRendererData.getSpiritInfluenceData(target), partialTicks, poseStack);
                ArtificeAcceptorRenderer.renderDebugGizmo(poseStack, target);
                poseStack.popPose();
            }
        });
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        ArtificeAcceptorRenderer.renderDebugGizmo(poseStack, target);
        poseStack.popPose();
    }

    public static void renderDebugGizmo(PoseStack stack, IArtificeAcceptor target) {
    }

    private static /* synthetic */ void lambda$renderDebugGizmo$3(LodestoneRenderTypes.LodestoneCompositeStateBuilder b) {
        b.setWriteMaskState(RenderStateShard.COLOR_WRITE).setDepthTestState(RenderStateShard.NO_DEPTH_TEST);
    }

    private static /* synthetic */ Color lambda$renderDebugGizmo$2(IArtificeAcceptor a) {
        return ColorHelper.getColor((int)Mth.abs((int)a.hashCode()));
    }

    public static interface ArtificeModifierSourceRenderer<T extends IArtificeModifierSource> {
        public void render(T var1, IArtificeAcceptor var2, SpiritInfluenceRendererData var3, float var4, PoseStack var5);
    }
}

