/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.renderpass.ParallelWorldRenderer;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.client.MalumRenderTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class VoidConduitRenderer
implements BlockEntityRenderer<VoidConduitBlockEntity> {
    public VoidConduitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidConduitBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float height = 0.375f;
        float width = 1.5f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.01f, 0.5f);
        LodestoneRenderTypeBuilder vignette = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.VOID_VIGNETTE);
        builder.replaceBufferSource(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setRenderType(vignette).renderQuad(poseStack, positions, 1.0f);
        long gameTime = blockEntityIn.getLevel().getGameTime();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        builder.replaceBufferSource((MultiBufferSource)LodestoneRenderHandler.DEFERRED_RENDER.getTarget());
        Color[] colors = new Color[]{MalumSpiritTypes.ELDRITCH_SPIRIT.getPrimaryColor(), MalumSpiritTypes.WICKED_SPIRIT.getSecondaryColor(), MalumSpiritTypes.AQUEOUS_SPIRIT.getPrimaryColor(), MalumSpiritTypes.AERIAL_SPIRIT.getSecondaryColor()};
        for (int i = 0; i < 4; ++i) {
            float speed = 1000.0f + 250.0f * (float)i;
            float alpha = 0.2f - (float)i * 0.05f;
            ShaderUniformHandler uniforms = new ShaderUniformHandler().modifyUniform("Speed", new float[]{speed}).modifyUniform("Width", new float[]{1024.0f}).modifyUniform("Height", new float[]{1024.0f}).setSamplerTexture("Skybox", ParallelWorldRenderer.INSTANCE.getTarget().getColorTextureId());
            LodestoneRenderTypeBuilder distortion = MalumRenderTypes.WEEPING_SPYHOLE.apply(MalumRenderTypeTokens.VOID_NOISE).withUniformHandler(uniforms);
            builder.setColor(colors[i]).setRenderType(distortion);
            builder.setAlpha(alpha);
            builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
            builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
            uOffset = -uOffset - 0.2f;
            vOffset = -vOffset + 0.4f;
            poseStack.translate(0.0f, 0.05f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(VoidConduitBlockEntity voidConduit) {
        BlockPos pos = voidConduit.getBlockPos();
        return new AABB((double)(pos.getX() - 2), (double)(pos.getY() - 2), (double)(pos.getZ() - 2), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
    }
}

