/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonCoreBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;

public class RepairPylonRenderer
implements BlockEntityRenderer<RepairPylonCoreBlockEntity> {
    public RepairPylonRenderer(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(RepairPylonCoreBlockEntity blockEntityIn) {
        BlockPos pos = blockEntityIn.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 5), (double)(pos.getZ() + 2));
    }

    public void render(RepairPylonCoreBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack;
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        LodestoneBlockEntityInventory inventory = blockEntityIn.spiritInventory;
        int spiritsRendered = 0;
        if (!inventory.isEmpty()) {
            for (int i = 0; i < inventory.slotCount; ++i) {
                ItemStack item = inventory.getStackInSlot(i);
                Item item2 = item.getItem();
                if (!(item2 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)item2;
                poseStack.pushPose();
                Vector3f offset = blockEntityIn.getSpiritItemOffset(spiritsRendered++, partialTicks).toVector3f();
                poseStack.translate(offset.x(), offset.y(), offset.z());
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, shardItem.getSpiritHolder(), partialTicks);
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
                poseStack.popPose();
            }
        }
        if (!(stack = blockEntityIn.inventory.getStackInSlot(0)).isEmpty()) {
            poseStack.pushPose();
            Vec3 offset = blockEntityIn.getCentralItemOffset();
            poseStack.translate(offset.x, offset.y, offset.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
    }
}

