/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlock;
import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlockEntity;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;

public class MoteOfManaRenderer
implements BlockEntityRenderer<ManaMoteBlockEntity> {
    public MoteOfManaRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ManaMoteBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = blockEntityIn.getBlockState();
        SpiritHolder<SpiritArcanaType> spirit = SpiritTypeProperty.getSpiritType(state);
        LodestoneRenderTypeBuilder additive = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(MalumRenderTypeTokens.MOTE_OF_MANA);
        LodestoneRenderTypeBuilder transparent = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.MOTE_OF_MANA);
        SpiritBasedWorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spirit);
        Color primaryColor = spirit.getPrimaryColor();
        Color secondaryColor = spirit.getSecondaryColor();
        float wobble = 1.0f;
        ArrayList<Direction> directions = new ArrayList<Direction>();
        ArrayList<Direction> invertedDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!ManaMoteBlock.isOccluded(state, direction)) {
                Direction usedDirection = direction;
                if (usedDirection.getAxis().isVertical()) {
                    usedDirection = usedDirection.getOpposite();
                }
                directions.add(usedDirection.getOpposite());
                invertedDirections.add(usedDirection);
                continue;
            }
            wobble -= 0.2f;
        }
        CubeVertexData cube = CubeVertexData.makeCubePositions((float)1.0f).applyWobble(0.0f, 0.5f, wobble * 0.02f);
        CubeVertexData inverse = CubeVertexData.makeCubePositions((float)-1.0f).applyWobble(0.0f, 0.5f, wobble * 0.02f);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        builder.setRenderType(transparent).setColor(primaryColor, 0.9f).renderCubeSides(poseStack, cube, directions);
        builder.setRenderType(additive).setAlpha(0.25f).renderCubeSides(poseStack, cube.scale(1.05f), directions);
        builder.setColor(secondaryColor, 0.4f).renderCubeSides(poseStack, inverse.scale(0.95f), invertedDirections);
        poseStack.popPose();
    }
}

