/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.cosmetic;

import com.sammy.malum.client.cosmetic.PrideArmorSkinRenderingData;
import com.sammy.malum.client.cosmetic.SimpleArmorSkinRenderingData;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.registry.client.MalumModels;
import java.util.HashMap;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public abstract class ArmorSkinRenderingData {
    public static HashMap<ItemSkinComponent, ArmorSkinRenderingData> ARMOR_RENDERING_DATA = new HashMap();

    private static void addPrideData(ItemSkinComponent component) {
        ARMOR_RENDERING_DATA.put(component, new PrideArmorSkinRenderingData(component));
    }

    private static void addData(ItemSkinComponent component, LodestoneArmorModel model) {
        ARMOR_RENDERING_DATA.put(component, new SimpleArmorSkinRenderingData(component, model));
    }

    public abstract ResourceLocation getTexture(LivingEntity var1, boolean var2);

    protected abstract LodestoneArmorModel getModel(LivingEntity var1, boolean var2);

    public ResourceLocation getTexture(LivingEntity livingEntity) {
        return this.getTexture(livingEntity, ArmorSkinRenderingData.isSlim(livingEntity));
    }

    public final LodestoneArmorModel getModel(LivingEntity livingEntity) {
        return this.getModel(livingEntity, ArmorSkinRenderingData.isSlim(livingEntity));
    }

    public static boolean isSlim(LivingEntity livingEntity) {
        if (!(livingEntity instanceof AbstractClientPlayer)) {
            return false;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
        PlayerSkin.Model model = player.getSkin().model();
        return model.id().equals("slim");
    }

    static {
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.ACE);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.AGENDER);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.ARO);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.AROACE);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.BI);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.DEMIBOY);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.DEMIGIRL);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.ENBY);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.GAY);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.GENDERFLUID);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.GENDERQUEER);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.INTERSEX);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.LESBIAN);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.PAN);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.PLURAL);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.POLY);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.PRIDE);
        ArmorSkinRenderingData.addPrideData(ItemSkinComponent.TRANS);
        ArmorSkinRenderingData.addData(ItemSkinComponent.BLUE_MACHINE, MalumModels.ULTRAKILL_MACHINE);
        ArmorSkinRenderingData.addData(ItemSkinComponent.RED_MACHINE, MalumModels.ULTRAKILL_MACHINE);
        ArmorSkinRenderingData.addData(ItemSkinComponent.COMMANDO, MalumModels.COMMANDO);
        ArmorSkinRenderingData.addData(ItemSkinComponent.ANCIENT_CLOTH, MalumModels.ANCIENT_SOUL_HUNTER_ARMOR);
        ArmorSkinRenderingData.addData(ItemSkinComponent.ANCIENT_METAL, MalumModels.ANCIENT_SOUL_STAINED_STEEL_ARMOR);
    }
}

