/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;

@EventBusSubscriber
public class CoinsCommand {
    private static int addCoins(final CommandContext<CommandSourceStack> arguments) {
        Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
        Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
        if (players == null && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        if (players == null) {
            return 0;
        }
        int amount = IntegerArgumentType.getInteger(arguments, (String)"amount");
        Entity player = new Object(){

            public Entity getEntity() {
                try {
                    return EntityArgument.getEntity((CommandContext)arguments, (String)"players");
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }.getEntity();
        MagicCoinsApi.addCoins(player, amount);
        String coinText = Component.translatable((String)(amount == 1 ? "text.coin" : "text.coins")).getString();
        String message = Component.translatable((String)"command.coins.add.success").getString();
        message = String.format(message, amount, player.getName().getString(), coinText);
        ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7a" + message)));
        return 1;
    }

    private static int setCoins(final CommandContext<CommandSourceStack> arguments) {
        Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
        Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
        if (players == null && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        if (players != null) {
            // empty if block
        }
        int amount = IntegerArgumentType.getInteger(arguments, (String)"amount");
        Entity player = new Object(){

            public Entity getEntity() {
                try {
                    return EntityArgument.getEntity((CommandContext)arguments, (String)"players");
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }.getEntity();
        MagicCoinsApi.setTotalCoins(player, amount);
        String coinText = Component.translatable((String)(amount == 1 ? "text.coin" : "text.coins")).getString();
        String message = Component.translatable((String)"command.coins.set.success").getString();
        message = String.format(message, amount, player.getName().getString(), coinText);
        ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7a" + message)));
        return 1;
    }

    private static int getCoins(CommandContext<CommandSourceStack> arguments, Entity player) {
        Level level;
        ServerLevel serverLevel;
        Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
        Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
        if (players == null && world instanceof ServerLevel) {
            serverLevel = (ServerLevel)world;
            players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        if (players == null) {
            return 0;
        }
        if (player == null && (player = ((CommandSourceStack)arguments.getSource()).getEntity()) == null && (level = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            player = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        if (player != null) {
            int coins = MagicCoinsApi.getTotalCoins(player);
            ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("%s: \u00a7a$%d", player.getName().getString(), coins)));
        }
        return 1;
    }

    private static int rankCoins(CommandContext<CommandSourceStack> arguments, int page) {
        MinecraftServer server = ((CommandSourceStack)arguments.getSource()).getServer();
        Map<String, PlayerOnlineInfo> playersOnlineMap = server.getPlayerList().getPlayers().stream().map(p -> new PlayerOnlineInfo((ServerPlayer)p, p.getUUID().toString())).collect(Collectors.toMap(PlayerOnlineInfo::uuid, p -> p));
        File playerDataFolder = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toFile();
        ArrayList<PlayerCoinsInfo> ranking = new ArrayList<PlayerCoinsInfo>();
        for (PlayerOnlineInfo playerOnlineInfo : playersOnlineMap.values()) {
            int coins = MagicCoinsApi.getTotalCoins((Entity)playerOnlineInfo.player());
            String name2 = playerOnlineInfo.player().getName().getString();
            ranking.add(new PlayerCoinsInfo(name2, coins));
        }
        File[] files = playerDataFolder.listFiles((dir, name) -> name.endsWith(".dat"));
        if (files != null) {
            for (File file : files) {
                try {
                    String key;
                    CompoundTag attachments;
                    String fileUUID = file.getName().replace(".dat", "");
                    if (playersOnlineMap.containsKey(fileUUID)) continue;
                    int coins = 0;
                    String name3 = fileUUID;
                    CompoundTag nbt = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                    UUID uuid = UUID.fromString(fileUUID);
                    name3 = server.getProfileCache().get(uuid).map(GameProfile::getName).orElse(uuid.toString());
                    coins = 0;
                    if (nbt.contains("neoforge:attachments") && (attachments = nbt.getCompound("neoforge:attachments")).contains(key = "magic_coins:coins_in_bag")) {
                        coins = attachments.getCompound(key).getInt("ValueTotalInCoins");
                    }
                    ranking.add(new PlayerCoinsInfo(name3, coins));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ranking.sort((a, b) -> Integer.compare(b.coins(), a.coins()));
        int n = 10;
        int totalPages = (int)Math.ceil((double)ranking.size() / (double)n);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        int start = (page - 1) * n;
        int end = Math.min(start + n, ranking.size());
        String title = Component.translatable((String)"command.coins.rank.title").getString();
        String pageText = Component.translatable((String)"text.page").getString();
        ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("\u00a76-> %s (%s %d/%d) <-", title, pageText, page, totalPages)));
        for (int i = start; i < end; ++i) {
            PlayerCoinsInfo info = (PlayerCoinsInfo)ranking.get(i);
            ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("\u00a76%d. \u00a7f%s: \u00a7a$%d", i + 1, info.name(), info.coins())));
        }
        return 1;
    }

    @SubscribeEvent
    public static void registerCoinsCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"coins").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(s -> s.hasPermission(4))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(arguments -> CoinsCommand.addCoins((CommandContext<CommandSourceStack>)arguments)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(s -> s.hasPermission(4))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(arguments -> CoinsCommand.setCoins((CommandContext<CommandSourceStack>)arguments)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").requires(s -> s.hasPermission(0))).executes(arguments -> CoinsCommand.getCoins((CommandContext<CommandSourceStack>)arguments, null))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(arguments -> {
            Entity player = new Object(){

                public Entity getEntity() {
                    try {
                        return EntityArgument.getEntity((CommandContext)arguments, (String)"player");
                    }
                    catch (CommandSyntaxException e) {
                        ((CommandSourceStack)arguments.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7cPlayer not found"));
                        return null;
                    }
                }
            }.getEntity();
            return CoinsCommand.getCoins((CommandContext<CommandSourceStack>)arguments, player);
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"rank").executes(arguments -> CoinsCommand.rankCoins((CommandContext<CommandSourceStack>)arguments, 1))).then(((RequiredArgumentBuilder)Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).requires(s -> s.hasPermission(0))).executes(arguments -> {
            int page = IntegerArgumentType.getInteger((CommandContext)arguments, (String)"page");
            return CoinsCommand.rankCoins((CommandContext<CommandSourceStack>)arguments, page);
        }))));
    }

    public record PlayerOnlineInfo(ServerPlayer player, String uuid) {
    }

    public record PlayerCoinsInfo(String name, int coins) {
    }
}

