/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ComplexRenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

public class LodestoneRenderTypes
extends RenderStateShard {
    public static final Runnable TRANSPARENT_FUNCTION = () -> RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    public static final Runnable ADDITIVE_FUNCTION = () -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    public static final RenderStateShard.EmptyTextureStateShard NO_TEXTURE = RenderStateShard.NO_TEXTURE;
    public static final RenderStateShard.LightmapStateShard LIGHTMAP = RenderStateShard.LIGHTMAP;
    public static final RenderStateShard.LightmapStateShard NO_LIGHTMAP = RenderStateShard.NO_LIGHTMAP;
    public static final RenderStateShard.CullStateShard CULL = RenderStateShard.CULL;
    public static final RenderStateShard.CullStateShard NO_CULL = RenderStateShard.NO_CULL;
    public static final RenderStateShard.WriteMaskStateShard COLOR_DEPTH_WRITE = RenderStateShard.COLOR_DEPTH_WRITE;
    public static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = RenderStateShard.COLOR_WRITE;
    public static final LodestoneRenderType ADDITIVE_PARTICLE = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_PARTICLES), "additive_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType ADDITIVE_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_BLOCKS), "additive_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType ADDITIVE_BLOCK = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_BLOCKS), "additive_block", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType TRANSPARENT_PARTICLE = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_PARTICLES), "transparent_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType TRANSPARENT_BLOCK_PARTICLE = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_BLOCKS), "transparent_block_particle", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.PARTICLE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType TRANSPARENT_BLOCK = LodestoneRenderTypes.createGenericRenderType(RenderTypeToken.createToken(TextureAtlas.LOCATION_BLOCKS), "transparent_block", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, (LodestoneCompositeStateBuilder b) -> b.setStateShards(StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, NO_CULL, LIGHTMAP, COLOR_WRITE));
    public static final LodestoneRenderType LUMITRANSPARENT_PARTICLE = TRANSPARENT_PARTICLE.copy((Object)"lumitransparent", ShaderUniformHandler.LUMITRANSPARENT);
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK_PARTICLE = TRANSPARENT_BLOCK_PARTICLE.copy((Object)"lumitransparent", ShaderUniformHandler.LUMITRANSPARENT);
    public static final LodestoneRenderType LUMITRANSPARENT_BLOCK = TRANSPARENT_BLOCK.copy((Object)"lumitransparent", ShaderUniformHandler.LUMITRANSPARENT);
    public static final RenderTypeProvider TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "texture", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
    public static final RenderTypeProvider CUTOUT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "cutout_texture", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NO_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXTURE, CULL, LIGHTMAP)));
    public static final RenderTypeProvider TRANSPARENT_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "transparent_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP)));
    public static final RenderTypeProvider ADDITIVE_TEXT = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "additive_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, LodestoneShaders.LODESTONE_TEXT, LIGHTMAP, COLOR_WRITE)));
    public static final RenderTypeProvider TRANSPARENT_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_texture", token, LodestoneShaders.LODESTONE_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_distorted_texture", token, LodestoneShaders.DISTORTED_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_triangle_texture", token, LodestoneShaders.TRIANGLE_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_two_sided_triangle_texture", token, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_rounded_triangle_texture", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_scrolling_texture_triangle", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider TRANSPARENT_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_nine_slice_texture", token, LodestoneShaders.NINE_SLICE));
    public static final RenderTypeProvider TRANSPARENT_DISTORTED_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createTransparentRenderType("transparent_distorted_nine_slice_texture", token, LodestoneShaders.DISTORTED_NINE_SLICE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_texture", token, LodestoneShaders.LODESTONE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_DISTORTED_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_distorted_texture", token, LodestoneShaders.DISTORTED_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_triangle_texture", token, LodestoneShaders.TRIANGLE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_two_sided_triangle_texture", token, LodestoneShaders.TWO_SIDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_ROUNDED_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_rounded_triangle_texture", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_scrolling_texture_triangle", token, LodestoneShaders.ROUNDED_TRIANGLE_TEXTURE));
    public static final RenderTypeProvider ADDITIVE_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_nine_slice_texture", token, LodestoneShaders.NINE_SLICE));
    public static final RenderTypeProvider ADDITIVE_DISTORTED_NINE_SLICE_TEXTURE = new RenderTypeProvider(token -> LodestoneRenderTypes.createAdditiveRenderType("additive_distorted_nine_slice_texture", token, LodestoneShaders.DISTORTED_NINE_SLICE_TEXTURE));
    public static final RenderTypeProvider TEXTURE_FADE = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "texture_fade", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, LodestoneShaders.TEXTURE_FADE, CULL, LIGHTMAP)));
    public static final RenderTypeProvider DEBUG_SDF = new RenderTypeProvider(token -> LodestoneRenderTypes.createGenericRenderType(token, "debug_sdf", DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, LodestoneShaders.DEBUG_SDF, CULL)));

    public LodestoneRenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static LodestoneRenderType createTransparentRenderType(String name, RenderTypeToken token, ShaderHolder shader) {
        return LodestoneRenderTypes.createGenericRenderType(token, name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.NORMAL_TRANSPARENCY, shader, CULL, LIGHTMAP, COLOR_WRITE));
    }

    public static LodestoneRenderType createAdditiveRenderType(String name, RenderTypeToken token, ShaderHolder shader) {
        return LodestoneRenderTypes.createGenericRenderType(token, name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, LodestoneRenderTypes.builder(token, StateShards.ADDITIVE_TRANSPARENCY, shader, CULL, LIGHTMAP, COLOR_WRITE));
    }

    public static LodestoneRenderType createGenericRenderType(@Nullable RenderTypeToken token, String name, VertexFormat format, VertexFormat.Mode mode, Consumer<LodestoneCompositeStateBuilder> modifier) {
        LodestoneCompositeStateBuilder builder = new LodestoneCompositeStateBuilder();
        if (token != null) {
            builder.setTextureState(token);
        }
        modifier.accept(builder);
        return LodestoneRenderTypes.createGenericRenderType(token, name, format, mode, builder);
    }

    public static LodestoneRenderType createGenericRenderType(@Nullable RenderTypeToken token, String name, VertexFormat format, VertexFormat.Mode mode, LodestoneCompositeStateBuilder builder) {
        ShaderUniformHandler uniformHandler = null;
        if (token instanceof ComplexRenderTypeToken) {
            ComplexRenderTypeToken complex = (ComplexRenderTypeToken)token;
            uniformHandler = complex.getUniformHandler();
            if (complex.getModifier() != null) {
                complex.getModifier().accept(builder);
            }
        }
        VertexFormat.Mode renderTypeMode = builder.modeOverride != null ? builder.modeOverride : mode;
        RenderType.CompositeState compositeState = builder.createCompositeState();
        return new LodestoneRenderType(name, format, renderTypeMode, 256, false, true, compositeState, uniformHandler);
    }

    public static LodestoneCompositeStateBuilder builder(Object ... objects) {
        return LodestoneRenderTypes.builder().setStateShards(objects);
    }

    public static LodestoneCompositeStateBuilder builder() {
        return new LodestoneCompositeStateBuilder();
    }

    public static class LodestoneCompositeStateBuilder
    extends RenderType.CompositeState.CompositeStateBuilder {
        protected VertexFormat.Mode modeOverride;

        LodestoneCompositeStateBuilder() {
        }

        public LodestoneCompositeStateBuilder replaceVertexFormat(VertexFormat.Mode mode) {
            this.modeOverride = mode;
            return this;
        }

        public LodestoneCompositeStateBuilder accepts(Consumer<LodestoneCompositeStateBuilder> modifier) {
            modifier.accept(this);
            return this;
        }

        public LodestoneCompositeStateBuilder setStateShards(Object ... objects) {
            for (Object object : objects) {
                if (!(object instanceof RenderType.CompositeState)) continue;
                RenderType.CompositeState state = (RenderType.CompositeState)object;
                this.copyState(state);
            }
            Object[] objectArray = objects;
            int n = objectArray.length;
            block21: for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = objectArray[i];
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourceLocation.class, RenderTypeToken.class, RenderStateShard.EmptyTextureStateShard.class, ShaderInstance.class, ShaderHolder.class, RenderStateShard.ShaderStateShard.class, RenderStateShard.TransparencyStateShard.class, RenderStateShard.DepthTestStateShard.class, RenderStateShard.CullStateShard.class, RenderStateShard.LightmapStateShard.class, RenderStateShard.OverlayStateShard.class, RenderStateShard.LayeringStateShard.class, RenderStateShard.OutputStateShard.class, RenderStateShard.TexturingStateShard.class, RenderStateShard.WriteMaskStateShard.class, RenderStateShard.LineStateShard.class, RenderStateShard.ColorLogicStateShard.class}, (Object)object2, n2)) {
                    case 0: {
                        ResourceLocation texture = (ResourceLocation)object2;
                        this.setTextureState(texture);
                        continue block21;
                    }
                    case 1: {
                        RenderTypeToken token = (RenderTypeToken)object2;
                        this.setTextureState(token);
                        continue block21;
                    }
                    case 2: {
                        RenderStateShard.EmptyTextureStateShard shard = (RenderStateShard.EmptyTextureStateShard)object2;
                        this.setTextureState(shard);
                        continue block21;
                    }
                    case 3: {
                        ShaderInstance shaderInstance = (ShaderInstance)object2;
                        this.setShaderState(shaderInstance);
                        continue block21;
                    }
                    case 4: {
                        ShaderHolder shaderHolder = (ShaderHolder)object2;
                        this.setShaderState(shaderHolder);
                        continue block21;
                    }
                    case 5: {
                        RenderStateShard.ShaderStateShard shard = (RenderStateShard.ShaderStateShard)object2;
                        this.setShaderState(shard);
                        continue block21;
                    }
                    case 6: {
                        RenderStateShard.TransparencyStateShard shard = (RenderStateShard.TransparencyStateShard)object2;
                        this.setTransparencyState(shard);
                        continue block21;
                    }
                    case 7: {
                        RenderStateShard.DepthTestStateShard shard = (RenderStateShard.DepthTestStateShard)object2;
                        this.setDepthTestState(shard);
                        continue block21;
                    }
                    case 8: {
                        RenderStateShard.CullStateShard shard = (RenderStateShard.CullStateShard)object2;
                        this.setCullState(shard);
                        continue block21;
                    }
                    case 9: {
                        RenderStateShard.LightmapStateShard shard = (RenderStateShard.LightmapStateShard)object2;
                        this.setLightmapState(shard);
                        continue block21;
                    }
                    case 10: {
                        RenderStateShard.OverlayStateShard shard = (RenderStateShard.OverlayStateShard)object2;
                        this.setOverlayState(shard);
                        continue block21;
                    }
                    case 11: {
                        RenderStateShard.LayeringStateShard shard = (RenderStateShard.LayeringStateShard)object2;
                        this.setLayeringState(shard);
                        continue block21;
                    }
                    case 12: {
                        RenderStateShard.OutputStateShard shard = (RenderStateShard.OutputStateShard)object2;
                        this.setOutputState(shard);
                        continue block21;
                    }
                    case 13: {
                        RenderStateShard.TexturingStateShard shard = (RenderStateShard.TexturingStateShard)object2;
                        this.setTexturingState(shard);
                        continue block21;
                    }
                    case 14: {
                        RenderStateShard.WriteMaskStateShard shard = (RenderStateShard.WriteMaskStateShard)object2;
                        this.setWriteMaskState(shard);
                        continue block21;
                    }
                    case 15: {
                        RenderStateShard.LineStateShard shard = (RenderStateShard.LineStateShard)object2;
                        this.setLineState(shard);
                        continue block21;
                    }
                    case 16: {
                        RenderStateShard.ColorLogicStateShard shard = (RenderStateShard.ColorLogicStateShard)object2;
                        this.setColorLogicState(shard);
                        continue block21;
                    }
                    case -1: {
                        LodestoneLib.LOGGER.warn("Null object passed for composite state, ignoring.");
                        continue block21;
                    }
                    default: {
                        LodestoneLib.LOGGER.warn("Unsupported object passed for composite state: {}, {}", (Object)object.getClass().getName(), object);
                    }
                }
            }
            return this;
        }

        public LodestoneCompositeStateBuilder copyState(RenderType.CompositeState state) {
            this.setTextureState(state.textureState);
            this.setShaderState(state.shaderState);
            this.setTransparencyState(state.transparencyState);
            this.setDepthTestState(state.depthTestState);
            this.setCullState(state.cullState);
            this.setLightmapState(state.lightmapState);
            this.setOverlayState(state.overlayState);
            this.setLayeringState(state.layeringState);
            this.setOutputState(state.outputState);
            this.setTexturingState(state.texturingState);
            this.setWriteMaskState(state.writeMaskState);
            this.setLineState(state.lineState);
            this.setColorLogicState(state.colorLogicState);
            return this;
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderTypeToken token) {
            return this.setTextureState(token.getTexture());
        }

        public LodestoneCompositeStateBuilder setTextureState(ResourceLocation texture) {
            return this.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
        }

        public LodestoneCompositeStateBuilder setShaderState(ShaderInstance shaderInstance) {
            return this.setShaderState(new RenderStateShard.ShaderStateShard(() -> shaderInstance));
        }

        public LodestoneCompositeStateBuilder setShaderState(ShaderHolder shaderHolder) {
            return this.setShaderState(shaderHolder.getShard());
        }

        public RenderType.CompositeState createCompositeState() {
            return super.createCompositeState(true);
        }

        public LodestoneCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
            return (LodestoneCompositeStateBuilder)super.setTextureState(pTextureState);
        }

        public LodestoneCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
            return (LodestoneCompositeStateBuilder)super.setShaderState(pShaderState);
        }

        public LodestoneCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
            return (LodestoneCompositeStateBuilder)super.setTransparencyState(pTransparencyState);
        }

        public LodestoneCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
            return (LodestoneCompositeStateBuilder)super.setDepthTestState(pDepthTestState);
        }

        public LodestoneCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
            return (LodestoneCompositeStateBuilder)super.setCullState(pCullState);
        }

        public LodestoneCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
            return (LodestoneCompositeStateBuilder)super.setLightmapState(pLightmapState);
        }

        public LodestoneCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
            return (LodestoneCompositeStateBuilder)super.setOverlayState(pOverlayState);
        }

        public LodestoneCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
            return (LodestoneCompositeStateBuilder)super.setLayeringState(pLayerState);
        }

        public LodestoneCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
            return (LodestoneCompositeStateBuilder)super.setOutputState(pOutputState);
        }

        public LodestoneCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
            return (LodestoneCompositeStateBuilder)super.setTexturingState(pTexturingState);
        }

        public LodestoneCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
            return (LodestoneCompositeStateBuilder)super.setWriteMaskState(pWriteMaskState);
        }

        public LodestoneCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
            return (LodestoneCompositeStateBuilder)super.setLineState(pLineState);
        }
    }
}

