/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import org.joml.Matrix4f;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleItemStackRetrievalKey;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ScreenParticleHandler {
    public static final Map<ScreenParticleItemStackKey, ScreenParticleHolder> ITEM_PARTICLES = new HashMap<ScreenParticleItemStackKey, ScreenParticleHolder>();
    public static final Map<ScreenParticleItemStackRetrievalKey, ItemStack> ITEM_STACK_CACHE = new HashMap<ScreenParticleItemStackRetrievalKey, ItemStack>();
    public static final Collection<ScreenParticleItemStackRetrievalKey> ACTIVELY_ACCESSED_KEYS = new ArrayList<ScreenParticleItemStackRetrievalKey>();
    public static ScreenParticleHolder cachedItemParticles = null;
    public static int currentItemX;
    public static int currentItemY;
    public static boolean canSpawnParticles;
    public static boolean renderingHotbar;

    public static void tickParticles() {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        ITEM_PARTICLES.values().forEach(ScreenParticleHolder::tick);
        ITEM_PARTICLES.values().removeIf(ScreenParticleHolder::isEmpty);
        ITEM_STACK_CACHE.keySet().removeIf(k -> !ACTIVELY_ACCESSED_KEYS.contains(k));
        ACTIVELY_ACCESSED_KEYS.clear();
        canSpawnParticles = true;
    }

    public static void renderTick(RenderFrameEvent.Post event) {
        canSpawnParticles = false;
    }

    public static void renderItemStackEarly(PoseStack poseStack, ItemStack stack, int x, int y) {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && minecraft.player != null) {
            List<ParticleEmitterHandler.ItemParticleSupplier> emitters;
            if (minecraft.isPaused()) {
                return;
            }
            if (!stack.isEmpty() && (emitters = ParticleEmitterHandler.EMITTERS.get(stack.getItem())) != null) {
                Matrix4f pose = poseStack.last().pose();
                currentItemX = x + 8;
                currentItemY = y + 8;
                if (currentItemX == 8 && currentItemY == 8) {
                    int poseOffsetX = (int)pose.m30();
                    int poseOffsetY = (int)pose.m31();
                    currentItemX += poseOffsetX;
                    currentItemY += poseOffsetY;
                }
                for (ParticleEmitterHandler.ItemParticleSupplier emitter : emitters) {
                    ScreenParticleHandler.spawnAndPullParticles(minecraft.level, emitter, stack, false).render(poseStack);
                    cachedItemParticles = ScreenParticleHandler.spawnAndPullParticles(minecraft.level, emitter, stack, true);
                }
            }
        }
    }

    public static void renderItemStackLate(PoseStack poseStack) {
        if (cachedItemParticles != null) {
            cachedItemParticles.render(poseStack);
            cachedItemParticles = null;
        }
    }

    public static ScreenParticleHolder spawnAndPullParticles(ClientLevel level, ParticleEmitterHandler.ItemParticleSupplier emitter, ItemStack stack, boolean isRenderedAfterItem) {
        ScreenParticleItemStackRetrievalKey cacheKey = new ScreenParticleItemStackRetrievalKey(renderingHotbar, isRenderedAfterItem, currentItemX, currentItemY);
        ScreenParticleHolder target = ITEM_PARTICLES.computeIfAbsent(new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, stack), s -> new ScreenParticleHolder());
        ScreenParticleHandler.pullFromParticleVault(cacheKey, stack, target, isRenderedAfterItem);
        if (canSpawnParticles) {
            if (isRenderedAfterItem) {
                emitter.spawnLateParticles(target, (Level)level, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), stack, currentItemX, currentItemY);
            } else {
                emitter.spawnEarlyParticles(target, (Level)level, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), stack, currentItemX, currentItemY);
            }
        }
        ACTIVELY_ACCESSED_KEYS.add(cacheKey);
        return target;
    }

    public static void pullFromParticleVault(ScreenParticleItemStackRetrievalKey cacheKey, ItemStack currentStack, ScreenParticleHolder target, boolean isRenderedAfterItem) {
        ItemStack oldStack;
        if (ITEM_STACK_CACHE.containsKey(cacheKey) && (oldStack = ITEM_STACK_CACHE.get(cacheKey)) != currentStack && oldStack.getItem().equals(currentStack.getItem())) {
            ScreenParticleItemStackKey oldKey = new ScreenParticleItemStackKey(renderingHotbar, isRenderedAfterItem, oldStack);
            ScreenParticleHolder oldParticles = ITEM_PARTICLES.get(oldKey);
            if (oldParticles != null) {
                target.addFrom(oldParticles);
            }
            ITEM_STACK_CACHE.remove(cacheKey);
            ITEM_PARTICLES.remove(oldKey);
        }
        ITEM_STACK_CACHE.put(cacheKey, currentStack);
    }

    @Deprecated
    protected static void renderParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.render();
    }

    @Deprecated
    protected static void renderParticles(ScreenParticleHolder screenParticleTarget, @Nullable PoseStack poseStack) {
        screenParticleTarget.render(poseStack);
    }

    public static void clearParticles() {
        ITEM_PARTICLES.values().forEach(ScreenParticleHandler::clearParticles);
    }

    public static void clearParticles(ScreenParticleHolder screenParticleTarget) {
        screenParticleTarget.particles.values().forEach(ArrayList::clear);
    }

    public static <T extends ScreenParticleOptions> ScreenParticle addParticle(ScreenParticleHolder screenParticleTarget, T options, double x, double y, double xMotion, double yMotion) {
        Minecraft minecraft = Minecraft.getInstance();
        ScreenParticleType<?> type = options.type;
        ScreenParticle particle = type.provider.createParticle(minecraft.level, options, x, y, xMotion, yMotion);
        ArrayList list = screenParticleTarget.particles.computeIfAbsent(options.renderType, a -> new ArrayList());
        list.add(particle);
        return particle;
    }
}

