/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerDataTracker
extends SavedData {
    private static final String DATA_NAME = "leaderboards_player_data";
    private final Map<UUID, Long> lastSeenTimes = new HashMap<UUID, Long>();
    private static PlayerDataTracker instance;

    public static PlayerDataTracker create() {
        return new PlayerDataTracker();
    }

    public static PlayerDataTracker load(CompoundTag tag, HolderLookup.Provider provider) {
        PlayerDataTracker data = new PlayerDataTracker();
        CompoundTag playerData = tag.getCompound("PlayerData");
        for (String key : playerData.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(key);
                long lastSeen = playerData.getLong(key);
                data.lastSeenTimes.put(uuid, lastSeen);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag playerData = new CompoundTag();
        for (Map.Entry<UUID, Long> entry : this.lastSeenTimes.entrySet()) {
            playerData.putLong(entry.getKey().toString(), entry.getValue().longValue());
        }
        tag.put("PlayerData", (Tag)playerData);
        return tag;
    }

    public static PlayerDataTracker get(ServerLevel level) {
        return (PlayerDataTracker)level.getDataStorage().computeIfAbsent(new SavedData.Factory(PlayerDataTracker::create, PlayerDataTracker::load, null), DATA_NAME);
    }

    public void updateLastSeen(UUID uuid, long time) {
        this.lastSeenTimes.put(uuid, time);
        this.setDirty();
    }

    public static long getLastSeen(UUID uuid) {
        return PlayerDataTracker.getInstance().lastSeenTimes.getOrDefault(uuid, 0L);
    }

    public Set<UUID> getAllPlayerUUIDs() {
        return this.lastSeenTimes.keySet();
    }

    public static void setInstance(PlayerDataTracker tracker) {
        instance = tracker;
    }

    private static PlayerDataTracker getInstance() {
        return instance;
    }
}

