/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.uncandango.kubejstweaks.kubejs.debug.DumpErroringRecipes;
import dev.uncandango.kubejstweaks.kubejs.event.NoOpEventJS;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PreRecipeEventJS
implements KubeEvent {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.+)\\[(\\d+)]");
    private final Map<ResourceLocation, JsonElement> recipeJsons;
    private static final Set<ResourceLocation> IGNORE_WARNING = new HashSet<ResourceLocation>();

    public PreRecipeEventJS(Map<ResourceLocation, JsonElement> recipeJsons) {
        this.recipeJsons = recipeJsons;
        DumpErroringRecipes.disable();
        IGNORE_WARNING.clear();
    }

    @HideFromJS
    public static boolean shouldIgnoreWarning(ResourceLocation rl) {
        return IGNORE_WARNING.contains(rl);
    }

    static JsonElement fromString(@Nullable String string) {
        if (string == null || string.isEmpty() || string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
            boolean lenient = jsonReader.isLenient();
            jsonReader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (Exception exception) {
            return JsonNull.INSTANCE;
        }
    }

    public void dumpErroringRecipes() {
        DumpErroringRecipes.enable();
    }

    public Stream<RecipeEntry> getEntry(Object obj) {
        List list;
        JsonPrimitive jp;
        ResourceLocation rl;
        String s;
        Pattern r;
        if ((obj instanceof CharSequence || obj instanceof NativeRegExp || obj instanceof Pattern) && (r = RegExpKJS.wrap((Object)(s = obj.toString()))) != null) {
            return this.filterRegex(r);
        }
        if (obj instanceof JsonPrimitive && (rl = ResourceLocation.tryParse((String)(jp = (JsonPrimitive)obj).getAsString())) != null) {
            return this.getEntry(rl);
        }
        if (obj instanceof CharSequence) {
            CharSequence cs = (CharSequence)obj;
            if (cs.charAt(0) == '@') {
                return this.filterByModId(cs.subSequence(1, cs.length()).toString());
            }
            rl = ResourceLocation.tryParse((String)obj.toString());
            if (rl != null) {
                return this.getEntry(rl);
            }
        }
        if ((list = ListJS.of((Object)obj)) != null) {
            ArrayList<Stream<RecipeEntry>> streams = new ArrayList<Stream<RecipeEntry>>();
            for (Object element : list) {
                streams.add(this.getEntry(element));
            }
            return streams.stream().flatMap(Function.identity());
        }
        return Stream.empty();
    }

    public void fixCondition(Object obj) {
        this.getEntry(obj).forEach(RecipeEntry::fixCondition);
    }

    public void fixItemAtKey(Object obj, String key) {
        this.getEntry(obj).forEach(entry -> entry.fixItemAtKey(key));
    }

    public void disable(Object obj) {
        this.getEntry(obj).forEach(RecipeEntry::disable);
    }

    public void ignoreWarning(Object obj) {
        this.getEntry(obj).forEach(RecipeEntry::ignoreWarning);
    }

    private Stream<RecipeEntry> getEntry(ResourceLocation rl) {
        JsonElement json = this.recipeJsons.get(rl);
        if (json == null) {
            return Stream.empty();
        }
        return Stream.of(new RecipeEntry(rl, json.getAsJsonObject()));
    }

    private Stream<RecipeEntry> filter(Predicate<RecipeEntry> predicate) {
        return this.recipeJsons.entrySet().stream().map(entry -> new RecipeEntry((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(predicate);
    }

    private Stream<RecipeEntry> filterRegex(Pattern regex) {
        return this.filter(recipe -> regex.asPredicate().test(recipe.id.toString()));
    }

    private Stream<RecipeEntry> filterByModId(String modId) {
        return this.filter(recipe -> recipe.id().getNamespace().equals(modId));
    }

    public record RecipeEntry(ResourceLocation id, JsonObject json) {
        private static void fixItem(JsonElement keyValue) {
            JsonObject obj;
            if (keyValue instanceof JsonObject && (obj = (JsonObject)keyValue).has("item")) {
                obj.add("id", obj.remove("item"));
            }
            if (keyValue instanceof JsonArray) {
                JsonArray array = (JsonArray)keyValue;
                for (JsonElement element : array) {
                    RecipeEntry.fixItem(element);
                }
            }
        }

        public Optional<Pair<JsonElement, JsonElement>> fromPath(String path) {
            return this.fromPath(path, null);
        }

        public void ignoreWarning() {
            IGNORE_WARNING.add(this.id);
        }

        public void disable() {
            NoOpEventJS.mergeJson(this.json.getAsJsonObject(), NoOpEventJS.NO_OP_CONDITION_OPS.get());
        }

        public void fixItemAtKey(String key) {
            if (this.json.has(key)) {
                JsonElement keyValue = this.json.get(key);
                RecipeEntry.fixItem(keyValue);
            }
        }

        public void replaceValueAtKey(String root, String key, String oldValue, String newValue) {
            if (!this.json.has(root)) {
                return;
            }
            if (key == null || key.isEmpty()) {
                RecipeEntry.replaceIfMatches(this.json, this.json.get(root), root, oldValue, newValue);
            }
            JsonElement rootObj = this.json.get(root);
            RecipeEntry.lookForKey(rootObj, key).forEach(pair -> RecipeEntry.replaceIfMatches((JsonObject)pair.getFirst(), (JsonElement)pair.getSecond(), key, oldValue, newValue));
        }

        private static List<Pair<JsonObject, JsonElement>> lookForKey(JsonElement element, String key) {
            ArrayList<Pair<JsonObject, JsonElement>> results = new ArrayList<Pair<JsonObject, JsonElement>>();
            if (element instanceof JsonArray) {
                JsonArray ja = (JsonArray)element;
                for (JsonElement value : ja) {
                    results.addAll(RecipeEntry.lookForKey(value, key));
                }
            }
            if (element instanceof JsonObject) {
                JsonObject obj = (JsonObject)element;
                if (obj.has(key)) {
                    results.add((Pair<JsonObject, JsonElement>)new Pair((Object)obj, (Object)obj.get(key)));
                } else {
                    obj.asMap().values().forEach(jsons -> results.addAll(RecipeEntry.lookForKey(jsons, key)));
                }
            }
            return results;
        }

        private static void replaceIfMatches(JsonObject parent, JsonElement current, String key, String oldValue, String newValue) {
            if (current instanceof JsonPrimitive) {
                JsonPrimitive jp = (JsonPrimitive)current;
                if (jp.getAsString().equals(oldValue)) {
                    JsonElement newValueJson = PreRecipeEventJS.fromString(newValue);
                    if (newValueJson.isJsonNull()) {
                        newValueJson = new JsonPrimitive(newValue);
                    }
                    parent.add(key, newValueJson);
                }
            } else if (current.toString().equals(oldValue)) {
                parent.add(key, PreRecipeEventJS.fromString(newValue));
            }
        }

        public void fixCondition() {
            if (!this.json.has("conditions")) {
                return;
            }
            JsonArray conditions = this.json.remove("conditions").getAsJsonArray();
            for (JsonElement condition : conditions) {
                if (!(condition instanceof JsonObject)) continue;
                JsonObject jo = (JsonObject)condition;
                RecipeEntry.fixConditionType(jo);
            }
            this.json.add("neoforge:conditions", (JsonElement)conditions);
        }

        private static void fixConditionType(JsonObject condition) {
            if (!condition.has("type")) {
                return;
            }
            JsonPrimitive type = condition.get("type").getAsJsonPrimitive();
            if (type.getAsString().startsWith("forge:")) {
                condition.add("type", (JsonElement)new JsonPrimitive(type.getAsString().replace("forge:", "neoforge:")));
            }
            if (condition.has("value")) {
                RecipeEntry.fixConditionType(condition.get("value").getAsJsonObject());
            }
            if (condition.has("values")) {
                for (JsonElement value : condition.get("values").getAsJsonArray()) {
                    RecipeEntry.fixConditionType(value.getAsJsonObject());
                }
            }
        }

        public void renameKey(String oldKey, String newKey, boolean toArray) {
            if (this.json.has(oldKey)) {
                JsonElement newValue = this.json.remove(oldKey);
                if (toArray && !newValue.isJsonArray()) {
                    JsonArray array = new JsonArray();
                    array.add(newValue);
                    newValue = array;
                }
                this.json.add(newKey, newValue);
            }
        }

        public void addItemTagCondition(String tag) {
            JsonObject notCond = new JsonObject();
            notCond.add("type", (JsonElement)new JsonPrimitive("neoforge:not"));
            JsonObject tagCondition = new JsonObject();
            tagCondition.add("type", (JsonElement)new JsonPrimitive("neoforge:tag_empty"));
            tagCondition.add("tag", (JsonElement)new JsonPrimitive(tag));
            notCond.add("value", (JsonElement)tagCondition);
            this.addCondition(notCond);
        }

        public void addConditionsFromKey(String key) {
            JsonElement targetObj = this.json.getAsJsonObject().get(key);
            this.findConditions(targetObj);
        }

        private void findConditions(JsonElement target) {
            if (target instanceof JsonObject) {
                JsonElement tag;
                JsonElement itemId;
                JsonObject obj = (JsonObject)target;
                JsonElement item = obj.get("item");
                if (item != null && item.isJsonPrimitive()) {
                    this.addItemCondition(item.getAsString());
                }
                if ((itemId = obj.get("id")) != null && itemId.isJsonPrimitive()) {
                    this.addItemCondition(itemId.getAsString());
                }
                if ((tag = obj.get("tag")) != null && tag.isJsonPrimitive()) {
                    this.addItemTagCondition(tag.getAsString());
                }
                for (JsonElement value : obj.asMap().values()) {
                    this.findConditions(value);
                }
            }
            if (target instanceof JsonArray) {
                JsonArray array = (JsonArray)target;
                for (JsonElement obj : array) {
                    this.findConditions(obj);
                }
            }
        }

        public void addModConditionFromType() {
            JsonElement type = this.json.get("type");
            if (type == null) {
                return;
            }
            JsonObject condition = new JsonObject();
            condition.add("type", (JsonElement)new JsonPrimitive("neoforge:mod_loaded"));
            ResourceLocation rl = ResourceLocation.tryParse((String)type.getAsString());
            if (rl == null) {
                return;
            }
            condition.add("modid", (JsonElement)new JsonPrimitive(rl.getNamespace()));
            this.addCondition(condition);
        }

        public void addItemCondition(String item) {
            JsonObject itemCond = new JsonObject();
            itemCond.add("type", (JsonElement)new JsonPrimitive("neoforge:item_exists"));
            itemCond.add("item", (JsonElement)new JsonPrimitive(item));
            this.addCondition(itemCond);
        }

        private void addCondition(JsonObject condition) {
            if (this.json.has("neoforge:conditions")) {
                JsonArray conditions = this.json.get("neoforge:conditions").getAsJsonArray();
                conditions.add((JsonElement)condition);
            } else {
                JsonArray conditions = new JsonArray();
                conditions.add((JsonElement)condition);
                this.json.add("neoforge:conditions", (JsonElement)conditions);
            }
        }

        public Optional<Pair<JsonElement, JsonElement>> fromPath(String path, String expectedValue) {
            String normalized;
            JsonPrimitive prim;
            if (path == null || path.isEmpty()) {
                return Optional.empty();
            }
            String[] tokens = path.split("\\.");
            JsonObject current = this.json;
            JsonObject parent = null;
            for (String token : tokens) {
                if (current == null || current.isJsonNull()) {
                    return Optional.empty();
                }
                Matcher matcher = ARRAY_PATTERN.matcher(token);
                String key = token;
                Integer arrayIndex = null;
                if (matcher.matches()) {
                    key = matcher.group(1);
                    arrayIndex = Integer.parseInt(matcher.group(2));
                }
                if (!current.isJsonObject()) {
                    return Optional.empty();
                }
                JsonObject obj = current.getAsJsonObject();
                if (!obj.has(key)) {
                    return Optional.empty();
                }
                parent = obj;
                current = obj.get(key);
                if (arrayIndex == null) continue;
                if (!current.isJsonArray()) {
                    return Optional.empty();
                }
                JsonArray arr = current.getAsJsonArray();
                if (arrayIndex < 0 || arrayIndex >= arr.size()) {
                    return Optional.empty();
                }
                parent = arr;
                current = arr.get(arrayIndex.intValue());
            }
            if (expectedValue != null && (current.isJsonPrimitive() ? !(prim = current.getAsJsonPrimitive()).getAsString().equals(expectedValue) : !(normalized = current.toString()).equals(expectedValue))) {
                return Optional.empty();
            }
            return Optional.of(Pair.of(parent, (Object)current));
        }
    }
}

