/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.TickDuration;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MobEffectUtil {
    @Info(value="Copies an existing MobEffectInstance")
    @Contract(value="_ -> new")
    @NotNull
    public static MobEffectInstance of(MobEffectInstance oldInstance) {
        return new MobEffectInstance(oldInstance);
    }

    @Info(value="Creates an instance for the given effect. Default duration and amplifier is 0")
    @Contract(value="_ -> new")
    @NotNull
    public static MobEffectInstance of(Holder<MobEffect> effect) {
        return new MobEffectInstance(effect);
    }

    @Info(value="Creates an instance for the given effect and duration (in ticks)")
    @Contract(value="_, _ -> new")
    @NotNull
    public static MobEffectInstance of(Holder<MobEffect> effect, TickDuration duration) {
        return new MobEffectInstance(effect, duration.intTicks());
    }

    @Info(value="Creates an instance for the given effect, duration and amplifier")
    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MobEffectInstance of(Holder<MobEffect> effect, TickDuration duration, int amplifier) {
        return new MobEffectInstance(effect, duration.intTicks(), amplifier);
    }

    @Info(value="Creates an instance for the given effect, duration, amplifier, ambient, and visible to the HUD")
    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MobEffectInstance of(Holder<MobEffect> effect, TickDuration duration, int amplifier, boolean ambient, boolean visible) {
        return new MobEffectInstance(effect, duration.intTicks(), amplifier, ambient, visible);
    }

    @Info(value="Creates an instance for the given effect, duration, amplifier, ambient, visible to the HUD, and to show the icon on the sceen")
    @Contract(value="_, _, _, _, _, _ -> new")
    @NotNull
    public static MobEffectInstance of(Holder<MobEffect> effect, TickDuration duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        return new MobEffectInstance(effect, duration.intTicks(), amplifier, ambient, visible, showIcon);
    }
}

