/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.ticker;

import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.Actions;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TickerBE
extends BaseMachineBE
implements EnergyMachine,
FluidMachine,
RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);

    public TickerBE(BlockEntityType<?> p, BlockPos b, BlockState s) {
        super(p, b, s);
    }

    public TickerBE(BlockPos p, BlockState s) {
        this(null, p, s);
    }

    public void tickClient() {
    }

    public void tickServer() {
        if (this.isActiveRedstone()) {
            BlockPos pos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
            this.checkState(pos);
            if (((Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE)).booleanValue() && this.blockValid(pos)) {
                Actions.tickWhenRandom(pos, this.level);
                Actions.tickWhenBE(this.level, pos);
                this.playSound(pos);
                this.extractFEWhenPossible();
                this.extractMBWhenPossible();
            }
        }
    }

    public void checkState(BlockPos pos) {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(this.canExtractFE() && this.canExtractMB())));
    }

    public boolean blockValid(BlockPos pos) {
        return true;
    }

    public void playSound(BlockPos pos) {
        this.level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 100.0f, (float)LevelUtil.getRandomValue(9, this.level) * 0.1f, true);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    @Override
    public int getStandardEnergyCost() {
        return 100;
    }

    @Override
    public int getMaxEnergy() {
        return 10000;
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.PARADOX_FLUID_HANDLER);
    }

    @Override
    public int getStandardFluidCost() {
        return 0;
    }

    @Override
    public int getMaxMB() {
        return 0;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }
}

