/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.solar;

import com.devdyna.justdynathings.registry.interfaces.be.EnergyCharger;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyGenerator;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.Actions;
import com.devdyna.justdynathings.utils.DirectionUtil;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SolarBaseBE
extends BaseMachineBE
implements EnergyGenerator,
RedstoneControlledBE,
EnergyCharger {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();

    public SolarBaseBE(BlockEntityType<?> t, BlockPos p, BlockState b) {
        super(t, p, b);
        this.MACHINE_SLOTS = 1;
    }

    public SolarBaseBE(BlockPos p, BlockState b) {
        this(null, p, b);
    }

    public void tickServer() {
        this.updateBlock();
        if (this.isActiveRedstone() && ((Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE)).booleanValue()) {
            this.increaseFEWhenPossible(this.calculateFE());
        }
        if (this.canExtractFE()) {
            Actions.providePowerAdjacent(this.level, this.getBlockPos(), this.cache, this.calculateFE());
        }
        if (this.isActiveRedstone() && this.canExtractFE()) {
            this.chargeFEtoItemStack(this.level, this.getBlockPos(), this.getMachineHandler(), (IEnergyStorage)this.getEnergyStorage());
        }
    }

    public void updateBlock() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(this.canGenerateWhen())));
    }

    @Override
    public int getStandardEnergyCost() {
        return 0;
    }

    @Override
    public int getMaxEnergy() {
        return 0;
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_GENERATORS);
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    private int calculateFE() {
        float multiplier = 1.0f;
        if (this.enableMultiPopulator()) {
            int blocks = 1;
            for (BlockPos blockPos : DirectionUtil.around(this.getBlockPos())) {
                if (!this.level.getBlockState(blockPos).is(this.getBlockState().getBlock())) continue;
                ++blocks;
            }
            multiplier *= (float)(blocks / DirectionUtil.around(this.getBlockPos()).size() + 1);
        }
        if (this.enableMultiYLevel()) {
            int min = this.level.getMinBuildHeight();
            int max = this.level.getMaxBuildHeight() - 1;
            int y = this.getBlockPos().getY();
            float middle = (float)(min + max) / 2.0f;
            float unckecked = 1.0f - ((float)y - middle) / (float)(max - min) * (((float)y - middle) / (float)(max - min)) * 4.0f;
            unckecked = Math.max(unckecked, 0.0f);
            multiplier *= 0.05f + 0.95f * (1.0f - unckecked);
        }
        return (int)((float)this.FErate() * multiplier);
    }

    public int FErate() {
        return 0;
    }

    private boolean canGenerateWhen() {
        boolean result = true;
        if (this.enableCleanSky()) {
            result &= this.canSeeSky();
        }
        if (this.enableDayTimeOnly()) {
            result &= this.isDayTime();
        }
        boolean checkBiome = LevelUtil.isBiome(this.level, this.getBlockPos(), this.getBiomeTag());
        return result &= this.isAllowBiome() ? checkBiome : !checkBiome;
    }

    public boolean enableMultiPopulator() {
        return false;
    }

    public boolean enableMultiYLevel() {
        return false;
    }

    private boolean canSeeSky() {
        return this.level.canSeeSkyFromBelowWater(this.getBlockPos().above()) && this.level.getBlockState(this.getBlockPos().above()).isAir();
    }

    private boolean isDayTime() {
        return this.level.isDay();
    }

    public TagKey<Biome> getBiomeTag() {
        return null;
    }

    public boolean isAllowBiome() {
        return false;
    }

    public boolean enableCleanSky() {
        return true;
    }

    public boolean enableDayTimeOnly() {
        return true;
    }
}

