/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.paradox_mixer;

import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.recipetypes.type.ParadoxMixerRecipe;
import com.devdyna.justdynathings.registry.builders.stabilizer.StabilizerBlock;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.registry.types.zRecipeTypes;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ParadoxMixerBE
extends BaseMachineBE
implements FluidMachine {
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);

    public ParadoxMixerBE(BlockEntityType<?> type, BlockPos pos, BlockState b) {
        super(type, pos, b);
        this.MACHINE_SLOTS = 4;
    }

    public ParadoxMixerBE(BlockPos pos, BlockState b) {
        this((BlockEntityType)zBlockEntities.PARADOX_MIXER.get(), pos, b);
    }

    public void tickServer() {
        this.updateBlock();
        for (int i = 0; i < this.getMachineHandler().getSlots(); ++i) {
            ItemStack catalyst = this.getMachineHandler().getStackInSlot(i);
            List recipes = this.level.getRecipeManager().getAllRecipesFor(zRecipeTypes.PARADOX_MIXER.getType());
            Optional<RecipeHolder> recipe = recipes.stream().filter(r -> ((ParadoxMixerRecipe)r.value()).getCatalyst().test(catalyst) && this.getFluidStack().is(((ParadoxMixerRecipe)r.value()).getInput().getFluidType()) && this.getFluidStack().getAmount() == ((ParadoxMixerRecipe)r.value()).getInput().getAmount()).findFirst();
            if (!recipe.isPresent() || !((Boolean)this.getBlockState().getValue((Property)zProperties.GOO_ALIVE)).booleanValue()) continue;
            FluidStack fluid = ((ParadoxMixerRecipe)recipe.get().value()).getOutput();
            this.setFluidStack(fluid.getFluid(), fluid.getAmount());
            catalyst.shrink(1);
            if (((Boolean)common.PARADOX_MIXER_SOUND_EVENT.get()).booleanValue()) {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, (float)(this.level.random.nextInt(10) + 1) * 0.01f, (float)this.level.random.nextInt(50) + 0.01f);
            }
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.GOO_ALIVE, (Comparable)Boolean.valueOf(false)));
            break;
        }
    }

    public void updateBlock() {
        int i = 0;
        for (Direction dir : Direction.values()) {
            BlockState relative = this.level.getBlockState(this.getBlockPos().relative(dir));
            if (!(relative.getBlock() instanceof StabilizerBlock) || !((Direction)relative.getValue((Property)BlockStateProperties.FACING)).equals((Object)dir) || !((Boolean)relative.getValue((Property)zProperties.ENERGIZED)).booleanValue()) continue;
            ++i;
        }
        if (i <= 0) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.GOO_ALIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.MACHINE_FLUID_HANDLER);
    }

    @Override
    public int getMaxMB() {
        return (Integer)common.PARADOX_MIXER_MB_CAPACITY.get();
    }

    @Override
    public int getStandardFluidCost() {
        return 0;
    }
}

