/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.NumberButton;
import com.direwolf20.justdirethings.common.blockentities.ExperienceHolderBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.ExperienceHolderContainer;
import com.direwolf20.justdirethings.common.network.data.ExperienceHolderPayload;
import com.direwolf20.justdirethings.common.network.data.ExperienceHolderSettingsPayload;
import com.direwolf20.justdirethings.util.ExperienceUtils;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExperienceHolderScreen
extends BaseMachineScreen<ExperienceHolderContainer> {
    private ExperienceHolderBE experienceHolderBE;
    private int exp;
    private int targetExp;
    private boolean ownerOnly;
    private boolean collectExp;
    public boolean showParticles = true;
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_progress");

    public ExperienceHolderScreen(ExperienceHolderContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        BaseMachineBE baseMachineBE = container.baseMachineBE;
        if (baseMachineBE instanceof ExperienceHolderBE) {
            ExperienceHolderBE experienceHolderBE;
            this.experienceHolderBE = experienceHolderBE = (ExperienceHolderBE)baseMachineBE;
            this.exp = experienceHolderBE.exp;
            this.targetExp = experienceHolderBE.targetExp;
            this.ownerOnly = experienceHolderBE.ownerOnly;
            this.collectExp = experienceHolderBE.collectExp;
            this.showParticles = experienceHolderBE.showParticles;
        }
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.STOREEXPBUTTON(this.topSectionLeft + this.topSectionWidth / 2 + 15, this.topSectionTop + 62, true, b -> {
            int amt = 1;
            if (Screen.hasControlDown()) {
                amt = -1;
            } else if (Screen.hasShiftDown()) {
                amt *= 10;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ExperienceHolderPayload(true, amt), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.EXTRACTEXPBUTTON(this.topSectionLeft + this.topSectionWidth / 2 - 15 - 18, this.topSectionTop + 62, true, b -> {
            int amt = 1;
            if (Screen.hasControlDown()) {
                amt = -1;
            } else if (Screen.hasShiftDown()) {
                amt *= 10;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ExperienceHolderPayload(false, amt), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.TARGETEXPBUTTON(this.topSectionLeft + this.topSectionWidth / 2 - 15 - 42, this.topSectionTop + 64, this.targetExp, b -> {
            this.targetExp = ((NumberButton)b).getValue();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.OWNERONLYBUTTON(this.topSectionLeft + this.topSectionWidth / 2 - 15 - 60, this.topSectionTop + 62, this.ownerOnly, b -> {
            this.ownerOnly = !this.ownerOnly;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COLLECTEXPBUTTON(this.topSectionLeft + this.topSectionWidth / 2 + 15, this.topSectionTop + 42, this.collectExp, b -> {
            this.collectExp = !this.collectExp;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SHOWPARTICLESBUTTON(this.topSectionLeft + this.topSectionWidth / 2 + 31, this.topSectionTop + 42, this.showParticles, b -> {
            this.showParticles = !this.showParticles;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderXPBar(guiGraphics, partialTicks, mouseX, mouseY);
    }

    public void renderXPBar(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int barX = this.topSectionLeft + this.topSectionWidth / 2 - 91;
        int barY = this.topSectionTop + this.topSectionHeight - 15;
        guiGraphics.blitSprite(EXPERIENCE_BAR_BACKGROUND_SPRITE, barX, barY, 182, 5);
        int partialAmount = (int)(ExperienceUtils.getProgressToNextLevel(this.experienceHolderBE.exp) * 183.0f);
        if (partialAmount > 0) {
            guiGraphics.blitSprite(EXPERIENCE_BAR_PROGRESS_SPRITE, 182, 5, 0, 0, barX, barY, partialAmount, 5);
        }
        String s = String.valueOf(ExperienceUtils.getLevelFromTotalExperience(this.experienceHolderBE.exp));
        int j = this.topSectionLeft + this.topSectionWidth / 2 - this.font.width(s) / 2;
        Objects.requireNonNull(this.font);
        int k = this.topSectionTop + 62 + 9 / 2;
        guiGraphics.drawString(this.font, s, j + 1, k, 0, false);
        guiGraphics.drawString(this.font, s, j - 1, k, 0, false);
        guiGraphics.drawString(this.font, s, j, k + 1, 0, false);
        guiGraphics.drawString(this.font, s, j, k - 1, 0, false);
        guiGraphics.drawString(this.font, s, j, k, 8453920, false);
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new ExperienceHolderSettingsPayload(this.targetExp, this.ownerOnly, this.collectExp, this.showParticles), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

