/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.commoble.jumbofurnace.advancements.AssembleJumboFurnaceTrigger;
import net.commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import net.commoble.jumbofurnace.client.ClientProxy;
import net.commoble.jumbofurnace.config.ConfigHelper;
import net.commoble.jumbofurnace.config.ServerConfig;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceExteriorBlockEntity;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceItem;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceMenu;
import net.commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import net.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.commoble.jumbofurnace.recipes.RecipeSorter;
import net.commoble.jumbofurnace.recipes.SimpleRecipeSerializer;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="jumbofurnace")
public class JumboFurnace {
    private static JumboFurnace instance;
    public static final String MODID = "jumbofurnace";
    public static final TagKey<Block> JUMBOFURNACEABLE_TAG;
    public static final TagKey<Item> MULTIPROCESSING_UPGRADE_TAG;
    public final ServerConfig serverConfig;
    public final DeferredHolder<Block, JumboFurnaceBlock> jumboFurnaceBlock;
    public final DeferredHolder<Item, JumboFurnaceItem> jumboFurnaceItem;
    public final DeferredHolder<Item, Item> jumboFurnaceJeiDummy;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<JumboFurnaceCoreBlockEntity>> jumboFurnaceCoreBlockEntityType;
    public final DeferredHolder<BlockEntityType<?>, BlockEntityType<JumboFurnaceExteriorBlockEntity>> jumboFurnaceExteriorBlockEntityType;
    public final DeferredHolder<MenuType<?>, MenuType<JumboFurnaceMenu>> jumboFurnaceMenuType;
    public final DeferredHolder<RecipeType<?>, RecipeType<JumboFurnaceRecipe>> jumboSmeltingRecipeType;
    public final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<JumboFurnaceRecipe>> jumboSmeltingRecipeSerializer;
    public final DeferredHolder<CriterionTrigger<?>, AssembleJumboFurnaceTrigger> assembleJumboFurnaceTrigger;
    public final DeferredHolder<CriterionTrigger<?>, UpgradeJumboFurnaceTrigger> upgradeJumboFurnaceTrigger;

    public static JumboFurnace get() {
        return instance;
    }

    public JumboFurnace(IEventBus modBus) {
        if (instance != null) {
            throw new IllegalStateException("Jumbo Furnace initialized twice!");
        }
        instance = this;
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        this.serverConfig = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::create);
        DeferredRegister blocks = JumboFurnace.makeDeferredRegister(modBus, Registries.BLOCK);
        DeferredRegister items = JumboFurnace.makeDeferredRegister(modBus, Registries.ITEM);
        DeferredRegister blockEntities = JumboFurnace.makeDeferredRegister(modBus, Registries.BLOCK_ENTITY_TYPE);
        DeferredRegister menus = JumboFurnace.makeDeferredRegister(modBus, Registries.MENU);
        DeferredRegister recipeTypes = JumboFurnace.makeDeferredRegister(modBus, Registries.RECIPE_TYPE);
        DeferredRegister recipeSerializers = JumboFurnace.makeDeferredRegister(modBus, Registries.RECIPE_SERIALIZER);
        DeferredRegister triggerTypes = JumboFurnace.makeDeferredRegister(modBus, Registries.TRIGGER_TYPE);
        this.jumboFurnaceBlock = blocks.register("jumbo_furnace", () -> new JumboFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE)));
        this.jumboFurnaceItem = items.register("jumbo_furnace", () -> new JumboFurnaceItem(new Item.Properties()));
        this.jumboFurnaceJeiDummy = items.register("jumbo_furnace_jei", () -> new Item(this, new Item.Properties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
                tooltip.add((Component)Component.translatable((String)"jumbofurnace.jumbo_furnace_info_tooltip"));
            }
        });
        this.jumboFurnaceCoreBlockEntityType = blockEntities.register("jumbo_furnace_core", () -> BlockEntityType.Builder.of(JumboFurnaceCoreBlockEntity::create, (Block[])new Block[]{(Block)this.jumboFurnaceBlock.get()}).build(null));
        this.jumboFurnaceExteriorBlockEntityType = blockEntities.register("jumbo_furnace_exterior", () -> BlockEntityType.Builder.of(JumboFurnaceExteriorBlockEntity::create, (Block[])new Block[]{(Block)this.jumboFurnaceBlock.get()}).build(null));
        this.jumboFurnaceMenuType = menus.register("jumbo_furnace", () -> new MenuType(JumboFurnaceMenu::getClientMenu, FeatureFlags.VANILLA_SET));
        this.jumboSmeltingRecipeType = recipeTypes.register("jumbo_smelting", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"jumbo_smelting")));
        this.jumboSmeltingRecipeSerializer = recipeSerializers.register("jumbo_smelting", () -> new SimpleRecipeSerializer(JumboFurnaceRecipe.CODEC, JumboFurnaceRecipe.STREAM_CODEC));
        this.assembleJumboFurnaceTrigger = triggerTypes.register("assemble_jumbo_furnace", AssembleJumboFurnaceTrigger::new);
        this.upgradeJumboFurnaceTrigger = triggerTypes.register("upgrade_jumbo_furnace", UpgradeJumboFurnaceTrigger::new);
        modBus.addListener(this::onBuildCreativeTabs);
        modBus.addListener(this::onRegisterCapabilities);
        forgeBus.addListener(this::onAddServerReloadListeners);
        forgeBus.addListener(this::onEntityPlaceBlock);
        forgeBus.addListener(EventPriority.LOW, this::onRightClickBlockLow);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.addClientListeners(modBus, forgeBus);
        }
    }

    private static <T> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister register = DeferredRegister.create(registryKey, (String)MODID);
        register.register(modBus);
        return register;
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)this.jumboFurnaceExteriorBlockEntityType.get(), (be, side) -> be.getItemHandler((Direction)side));
    }

    private void onAddServerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RecipeSorter.INSTANCE);
    }

    private void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        block10: {
            BlockState state = event.getPlacedBlock();
            LevelAccessor levelAccess = event.getLevel();
            if (event instanceof BlockEvent.EntityMultiPlaceEvent || !state.is(JUMBOFURNACEABLE_TAG) || !(levelAccess instanceof Level)) break block10;
            Level level = (Level)levelAccess;
            BlockPos pos = event.getPos();
            BlockState againstState = event.getPlacedAgainst();
            Entity entity = event.getEntity();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            List<Pair<BlockPos, BlockState>> pairs = MultiBlockHelper.getJumboFurnaceStates((ResourceKey<Level>)((Level)levelAccess).dimension(), levelAccess, pos, againstState, entity);
            if (pairs.size() > 0) {
                for (Pair<BlockPos, BlockState> pair : pairs) {
                    BlockPos newPos = (BlockPos)pair.getFirst();
                    BlockState newState = (BlockState)pair.getSecond();
                    for (Direction dir : Direction.values()) {
                        IItemHandler sideHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, newPos, (Object)dir);
                        if (sideHandler == null) continue;
                        JumboFurnace.addItemsToList(stacks, sideHandler);
                    }
                    IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, newPos, null);
                    if (handler != null) {
                        JumboFurnace.addItemsToList(stacks, handler);
                    }
                    levelAccess.setBlock(newPos, newState, 3);
                }
                if (entity instanceof ServerPlayer) {
                    ((AssembleJumboFurnaceTrigger)((Object)this.assembleJumboFurnaceTrigger.get())).trigger((ServerPlayer)entity);
                }
            }
            if (!stacks.isEmpty()) {
                if (entity instanceof Player) {
                    for (ItemStack stack : stacks) {
                        ((Player)entity).addItem(stack);
                    }
                } else {
                    for (ItemStack stack : stacks) {
                        entity.spawnAtLocation(stack);
                    }
                }
            }
        }
    }

    private void onRightClickBlockLow(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)this.serverConfig.allowShearing().get()).booleanValue() && event.getUseItem() != TriState.FALSE && event.getUseBlock() != TriState.FALSE) {
            BlockPos pos;
            Level level;
            BlockState state;
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player.isSecondaryUseActive() && stack.is(Tags.Items.TOOLS_SHEAR) && (state = (level = event.getLevel()).getBlockState(pos = event.getPos())).getBlock() == this.jumboFurnaceBlock.get()) {
                if (!level.isClientSide) {
                    BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.jumboFurnaceItem.get()));
                    InteractionHand hand = event.getHand();
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    MultiBlockHelper.get3x3CubeAround(corePos).forEach(componentPos -> level.removeBlock(componentPos, true));
                }
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)this.jumboFurnaceItem.get());
        }
    }

    private static void addItemsToList(List<ItemStack> stacks, IItemHandler handler) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.extractItem(slot, 64, false);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        JUMBOFURNACEABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)JumboFurnace.id("jumbofurnaceable"));
        MULTIPROCESSING_UPGRADE_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)JumboFurnace.id("multiprocessing_upgrade"));
    }
}

