/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsClient;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CollectorBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.FACING;
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)10.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    private static final BlockShape[] SHAPES = new BlockShape[6];
    private final Supplier<BaseBlockEntityType<?>> entityType;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;

    public CollectorBlock(Supplier<BaseBlockEntityType<?>> entityType, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(false, BlockProperties.create().mapColor(MapColor.COLOR_BLACK).sound(SoundType.STONE).requiresCorrectTool().destroyTime(5.0f).explosionResistance(1200.0f));
        this.entityType = entityType;
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)Direction.DOWN));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (level.isClientSide && !this.hasFilter.get().booleanValue()) {
            ItemCollectorsClient.openBasicCollectorScreen(level, pos);
        } else if (!level.isClientSide && this.hasFilter.get().booleanValue()) {
            CommonUtils.openContainer((BaseContainer)new AdvancedCollectorContainer(ItemCollectors.filter_collector_container, player, level, pos));
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.entityType.get().create(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue(DIRECTION)).get3DDataValue()].getUnderlying();
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)("itemcollectors." + (this.hasFilter.get() != false ? "advanced" : "basic") + "_collector.info")).color(ChatFormatting.AQUA).get());
        info.accept((Component)TextComponents.translation((String)"itemcollectors.basic_collector.info.range", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(ChatFormatting.GOLD).get()}).get());
        super.appendItemInformation(stack, info, advanced);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)context.getClickedFace().getOpposite());
    }

    static {
        CollectorBlock.SHAPES[Direction.DOWN.get3DDataValue()] = SHAPE;
        CollectorBlock.SHAPES[Direction.UP.get3DDataValue()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.NORTH.get3DDataValue()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.EAST.get3DDataValue()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.SOUTH.get3DDataValue()] = SHAPE.rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.WEST.get3DDataValue()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y);
    }
}

